/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class MigrationPlanner {
    private static final boolean ASSERTION_ENABLED = MigrationPlanner.class.desiredAssertionStatus();
    private final ILogger logger;
    private final Address[] state = new Address[7];
    private final Set<Address> verificationSet = new HashSet<Address>();

    MigrationPlanner() {
        this.logger = Logger.getLogger(this.getClass());
    }

    MigrationPlanner(ILogger logger2) {
        this.logger = logger2;
    }

    void planMigrations(Address[] oldAddresses, Address[] newAddresses, MigrationDecisionCallback callback) {
        assert (oldAddresses.length == newAddresses.length) : "Replica addresses with different lengths! Old: " + Arrays.toString(oldAddresses) + ", New: " + Arrays.toString(newAddresses);
        this.log("Initial state: %s", Arrays.toString(oldAddresses));
        this.log("Final state: %s", Arrays.toString(newAddresses));
        this.initState(oldAddresses);
        this.assertNoDuplicate(oldAddresses, newAddresses);
        if (this.fixCycle(oldAddresses, newAddresses)) {
            this.log("Final state (after cycle fix): %s", Arrays.toString(newAddresses));
        }
        int currentIndex = 0;
        block0: while (currentIndex < oldAddresses.length) {
            this.log("Current index: %d, state: %s", currentIndex, Arrays.toString(this.state));
            this.assertNoDuplicate(oldAddresses, newAddresses);
            if (newAddresses[currentIndex] == null) {
                if (this.state[currentIndex] != null) {
                    this.log("New address is null at index: %d", currentIndex);
                    callback.migrate(this.state[currentIndex], currentIndex, -1, null, -1, -1);
                    this.state[currentIndex] = null;
                }
                ++currentIndex;
                continue;
            }
            if (this.state[currentIndex] == null) {
                int i = InternalPartitionImpl.getReplicaIndex(this.state, newAddresses[currentIndex]);
                if (i == -1) {
                    this.log("COPY %s to index: %d", newAddresses[currentIndex], currentIndex);
                    callback.migrate(null, -1, -1, newAddresses[currentIndex], -1, currentIndex);
                    this.state[currentIndex] = newAddresses[currentIndex];
                    ++currentIndex;
                    continue;
                }
                if (i > currentIndex) {
                    this.log("SHIFT UP-2 %s from old addresses index: %d to index: %d", this.state[i], i, currentIndex);
                    callback.migrate(null, -1, -1, this.state[i], i, currentIndex);
                    this.state[currentIndex] = this.state[i];
                    this.state[i] = null;
                    continue;
                }
                throw new AssertionError((Object)("Migration decision algorithm failed during SHIFT UP! INITIAL: " + Arrays.toString(oldAddresses) + ", CURRENT: " + Arrays.toString(this.state) + ", FINAL: " + Arrays.toString(newAddresses)));
            }
            if (newAddresses[currentIndex].equals(this.state[currentIndex])) {
                ++currentIndex;
                continue;
            }
            if (InternalPartitionImpl.getReplicaIndex(newAddresses, this.state[currentIndex]) == -1 && InternalPartitionImpl.getReplicaIndex(this.state, newAddresses[currentIndex]) == -1) {
                this.log("MOVE %s to index: %d", newAddresses[currentIndex], currentIndex);
                callback.migrate(this.state[currentIndex], currentIndex, -1, newAddresses[currentIndex], -1, currentIndex);
                this.state[currentIndex] = newAddresses[currentIndex];
                ++currentIndex;
                continue;
            }
            if (InternalPartitionImpl.getReplicaIndex(this.state, newAddresses[currentIndex]) == -1) {
                int newIndex = InternalPartitionImpl.getReplicaIndex(newAddresses, this.state[currentIndex]);
                assert (newIndex > currentIndex) : "Migration decision algorithm failed during SHIFT DOWN! INITIAL: " + Arrays.toString(oldAddresses) + ", CURRENT: " + Arrays.toString(this.state) + ", FINAL: " + Arrays.toString(newAddresses);
                if (this.state[newIndex] == null) {
                    this.log("SHIFT DOWN %s to index: %d, COPY %s to index: %d", this.state[currentIndex], newIndex, newAddresses[currentIndex], currentIndex);
                    callback.migrate(this.state[currentIndex], currentIndex, newIndex, newAddresses[currentIndex], -1, currentIndex);
                    this.state[newIndex] = this.state[currentIndex];
                } else {
                    this.log("MOVE-3 %s to index: %d", newAddresses[currentIndex], currentIndex);
                    callback.migrate(this.state[currentIndex], currentIndex, -1, newAddresses[currentIndex], -1, currentIndex);
                }
                this.state[currentIndex] = newAddresses[currentIndex];
                ++currentIndex;
                continue;
            }
            Address target = newAddresses[currentIndex];
            int i = currentIndex;
            while (true) {
                int j = InternalPartitionImpl.getReplicaIndex(this.state, target);
                assert (j != -1) : "Migration algorithm failed during SHIFT UP! " + target + " is not present in " + Arrays.toString(this.state) + ". INITIAL: " + Arrays.toString(oldAddresses) + ", FINAL: " + Arrays.toString(newAddresses);
                if (newAddresses[j] == null) {
                    if (this.state[i] == null) {
                        this.log("SHIFT UP %s from old addresses index: %d to index: %d", this.state[j], j, i);
                        callback.migrate(this.state[i], i, -1, this.state[j], j, i);
                        this.state[i] = this.state[j];
                    } else {
                        int k = InternalPartitionImpl.getReplicaIndex(newAddresses, this.state[i]);
                        if (k == -1) {
                            this.log("SHIFT UP %s from old addresses index: %d to index: %d with source: %s", this.state[j], j, i, this.state[i]);
                            callback.migrate(this.state[i], i, -1, this.state[j], j, i);
                            this.state[i] = this.state[j];
                        } else if (this.state[k] == null) {
                            this.log("SHIFT UP %s from old addresses index: %d to index: %d AND SHIFT DOWN %s to index: %d", this.state[j], j, i, this.state[i], k);
                            callback.migrate(this.state[i], i, k, this.state[j], j, i);
                            this.state[k] = this.state[i];
                            this.state[i] = this.state[j];
                        } else {
                            this.log("SHIFT UP %s from old addresses index: %d to index: %d with source: %s will get another MOVE migration to index: %d", this.state[j], j, i, this.state[i], k);
                            callback.migrate(this.state[i], i, -1, this.state[j], j, i);
                            this.state[i] = this.state[j];
                        }
                    }
                    this.state[j] = null;
                    continue block0;
                }
                if (InternalPartitionImpl.getReplicaIndex(this.state, newAddresses[j]) == -1) {
                    this.log("MOVE-2 %s  to index: %d", newAddresses[j], j);
                    callback.migrate(this.state[j], j, -1, newAddresses[j], -1, j);
                    this.state[j] = newAddresses[j];
                    continue block0;
                }
                target = newAddresses[j];
                i = j;
            }
        }
        assert (Arrays.equals(this.state, newAddresses)) : "Migration decisions failed! INITIAL: " + Arrays.toString(oldAddresses) + " CURRENT: " + Arrays.toString(this.state) + ", FINAL: " + Arrays.toString(newAddresses);
    }

    void prioritizeCopiesAndShiftUps(List<MigrationInfo> migrations) {
        for (int i = 0; i < migrations.size(); ++i) {
            this.prioritize(migrations, i);
        }
        if (ASSERTION_ENABLED) {
            this.log("Migration order after prioritization: ", new Object[0]);
            for (MigrationInfo migration : migrations) {
                this.log(migration.toString(), new Object[0]);
            }
        }
    }

    private void prioritize(List<MigrationInfo> migrations, int i) {
        int k;
        MigrationInfo migration = migrations.get(i);
        this.log("Trying to prioritize migration: %s", migration);
        if (migration.getSourceCurrentReplicaIndex() != -1) {
            this.log("Skipping non-copy migration: %s", migration);
            return;
        }
        for (k = i - 1; k >= 0; --k) {
            MigrationInfo other = migrations.get(k);
            if (other.getSourceCurrentReplicaIndex() == -1) {
                this.log("Cannot prioritize against a copy / shift up. other: %s", other);
                break;
            }
            if (migration.getDestination().equals(other.getSource()) || migration.getDestination().equals(other.getDestination())) {
                this.log("Cannot prioritize against a conflicting migration. other: %s", other);
                break;
            }
            if (other.getSourceNewReplicaIndex() == -1 || other.getSourceNewReplicaIndex() >= migration.getDestinationNewReplicaIndex()) continue;
            this.log("Cannot prioritize against a hotter shift down. other: %s", other);
            break;
        }
        if (k + 1 != i) {
            this.log("Prioritizing migration to: %d", k + 1);
            migrations.remove(i);
            migrations.add(k + 1, migration);
        }
    }

    private void initState(Address[] oldAddresses) {
        Arrays.fill(this.state, null);
        System.arraycopy(oldAddresses, 0, this.state, 0, oldAddresses.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNoDuplicate(Address[] oldAddresses, Address[] newAddresses) {
        if (!ASSERTION_ENABLED) {
            return;
        }
        try {
            for (Address address : this.state) {
                if (address != null) assert (this.verificationSet.add(address)) : "Migration decision algorithm failed! DUPLICATE REPLICA ADDRESSES! INITIAL: " + Arrays.toString(oldAddresses) + ", CURRENT: " + Arrays.toString(this.state) + ", FINAL: " + Arrays.toString(newAddresses);
            }
        }
        finally {
            this.verificationSet.clear();
        }
    }

    boolean isCyclic(Address[] oldReplicas, Address[] newReplicas) {
        for (int i = 0; i < oldReplicas.length; ++i) {
            Address oldAddress = oldReplicas[i];
            Address newAddress = newReplicas[i];
            if (oldAddress == null || newAddress == null || oldAddress.equals(newAddress) || !this.isCyclic(oldReplicas, newReplicas, i)) continue;
            return true;
        }
        return false;
    }

    boolean fixCycle(Address[] oldReplicas, Address[] newReplicas) {
        boolean cyclic = false;
        for (int i = 0; i < oldReplicas.length; ++i) {
            Address oldAddress = oldReplicas[i];
            Address newAddress = newReplicas[i];
            if (oldAddress == null || newAddress == null || oldAddress.equals(newAddress) || !this.isCyclic(oldReplicas, newReplicas, i)) continue;
            this.fixCycle(oldReplicas, newReplicas, i);
            cyclic = true;
        }
        return cyclic;
    }

    private boolean isCyclic(Address[] oldReplicas, Address[] newReplicas, int index) {
        Address newOwner = newReplicas[index];
        int firstIndex = index;
        int nextIndex;
        while ((nextIndex = InternalPartitionImpl.getReplicaIndex(newReplicas, oldReplicas[firstIndex])) != -1) {
            if (firstIndex == nextIndex) {
                return false;
            }
            if (newOwner.equals(oldReplicas[nextIndex])) {
                return true;
            }
            firstIndex = nextIndex;
        }
        return false;
    }

    private void fixCycle(Address[] oldReplicas, Address[] newReplicas, int index) {
        while (true) {
            int nextIndex = InternalPartitionImpl.getReplicaIndex(newReplicas, oldReplicas[index]);
            newReplicas[index] = oldReplicas[index];
            if (nextIndex == -1) {
                return;
            }
            index = nextIndex;
        }
    }

    private void log(String log, Object ... args) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format(log, args));
        }
    }

    static interface MigrationDecisionCallback {
        public void migrate(Address var1, int var2, int var3, Address var4, int var5, int var6);
    }
}

