/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;

public class ShutdownResponseOperation
extends Operation
implements MigrationCycleOperation {
    @Override
    public void run() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        ILogger logger2 = this.getLogger();
        Address caller = this.getCallerAddress();
        NodeEngine nodeEngine = this.getNodeEngine();
        ClusterService clusterService = nodeEngine.getClusterService();
        Address masterAddress = clusterService.getMasterAddress();
        if (nodeEngine.isRunning()) {
            logger2.severe("Received a shutdown response from " + caller + ", but this node is not shutting down!");
            return;
        }
        boolean fromMaster = masterAddress.equals(caller);
        if (fromMaster) {
            if (logger2.isFinestEnabled()) {
                logger2.finest("Received shutdown response from " + caller);
            }
            partitionService.onShutdownResponse();
        } else {
            logger2.warning("Received shutdown response from " + caller + " but known master is: " + masterAddress);
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }
}

