/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.logging.Logger;
import com.hazelcast.nio.UnsafeHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;

public final class JVMUtil {
    public static final int REFERENCE_COST_IN_BYTES = JVMUtil.isCompressedOops() ? 4 : 8;

    private JVMUtil() {
    }

    private static boolean isCompressedOops() {
        Boolean enabled = JVMUtil.isHotSpotCompressedOopsOrNull();
        if (enabled != null) {
            return enabled;
        }
        enabled = JVMUtil.isCompressedOopsOrNull();
        if (enabled != null) {
            return enabled;
        }
        return true;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private static Boolean isHotSpotCompressedOopsOrNull() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName mbean = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
            Object[] objects = new Object[]{"UseCompressedOops"};
            String[] strings = new String[]{"java.lang.String"};
            String operation = "getVMOption";
            CompositeDataSupport compressedOopsValue = (CompositeDataSupport)server.invoke(mbean, operation, objects, strings);
            return Boolean.valueOf(compressedOopsValue.get("value").toString());
        }
        catch (Exception e) {
            Logger.getLogger(JVMUtil.class).warning("Failed to read HotSpot specific configuration", e);
            return null;
        }
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private static Boolean isCompressedOopsOrNull() {
        int oopSize;
        if (!UnsafeHelper.UNSAFE_AVAILABLE) {
            return null;
        }
        try {
            long off1 = UnsafeHelper.UNSAFE.objectFieldOffset(CompressedOopsClass.class.getField("obj1"));
            long off2 = UnsafeHelper.UNSAFE.objectFieldOffset(CompressedOopsClass.class.getField("obj2"));
            oopSize = (int)Math.abs(off2 - off1);
        }
        catch (Exception e) {
            Logger.getLogger(JVMUtil.class).warning(e);
            return null;
        }
        return oopSize != UnsafeHelper.UNSAFE.addressSize();
    }

    private static class CompressedOopsClass {
        Object obj1;
        Object obj2;

        private CompressedOopsClass() {
        }
    }
}

