/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.admin.util.AuthenticationInfo;
import com.sun.enterprise.admin.util.HttpConnectorAddress;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecureAdminInternalUser;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.security.store.DomainScopedPasswordAliasStore;
import java.lang.annotation.Annotation;
import java.net.URLConnection;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.ServiceLocator;

public class ServerRemoteAdminCommand
extends RemoteAdminCommand {
    private static final String SSL_SOCKET_PROTOCOL = "TLS";
    private ServiceLocator habitat;
    private SecureAdmin secureAdmin;
    private ServerEnvironment serverEnv;
    private SSLUtils _sslUtils = null;
    private DomainScopedPasswordAliasStore domainPasswordAliasStore = null;

    public ServerRemoteAdminCommand(ServiceLocator habitat, String name, String host, int port, boolean secure, String user, String password, Logger logger2) throws CommandException {
        super(name, host, port, secure, "admin", "", logger2);
        super.setOmitCache(true);
        this.completeInit(habitat);
    }

    private synchronized void completeInit(ServiceLocator habitat) {
        this.habitat = habitat;
        Domain domain = habitat.getService(Domain.class, new Annotation[0]);
        this.secureAdmin = domain.getSecureAdmin();
        this.serverEnv = habitat.getService(ServerEnvironment.class, new Annotation[0]);
        this.secure = SecureAdmin.Util.isEnabled(this.secureAdmin);
        this.domainPasswordAliasStore = habitat.getService(DomainScopedPasswordAliasStore.class, new Annotation[0]);
        this.setInteractive(false);
    }

    @Override
    protected synchronized HttpConnectorAddress getHttpConnectorAddress(String host, int port, boolean shouldUseSecure) {
        try {
            String certAlias = SecureAdmin.Util.isUsingUsernamePasswordAuth(this.secureAdmin) ? null : this.getCertAlias();
            return new HttpConnectorAddress(host, port, certAlias == null ? null : this.sslUtils().getAdminSocketFactory(certAlias, SSL_SOCKET_PROTOCOL));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected synchronized AuthenticationInfo authenticationInfo() {
        SecureAdminInternalUser secureAdminInternalUser;
        AuthenticationInfo result = null;
        if (SecureAdmin.Util.isUsingUsernamePasswordAuth(this.secureAdmin) && (secureAdminInternalUser = SecureAdmin.Util.secureAdminInternalUser(this.secureAdmin)) != null) {
            try {
                result = new AuthenticationInfo(secureAdminInternalUser.getUsername(), new String(this.domainPasswordAliasStore.get(secureAdminInternalUser.getPasswordAlias())));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    @Override
    protected synchronized void addAdditionalHeaders(URLConnection urlConnection) {
        String indicatorValue = SecureAdmin.Util.configuredAdminIndicator(this.secureAdmin);
        if (indicatorValue != null) {
            urlConnection.setRequestProperty("X-GlassFish-admin", indicatorValue);
        }
    }

    private synchronized String getCertAlias() {
        return this.serverEnv.isDas() ? SecureAdmin.Util.DASAlias(this.secureAdmin) : SecureAdmin.Util.instanceAlias(this.secureAdmin);
    }

    private synchronized SSLUtils sslUtils() {
        if (this._sslUtils == null) {
            this._sslUtils = this.habitat.getService(SSLUtils.class, new Annotation[0]);
        }
        return this._sslUtils;
    }
}

