/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.customvalidators;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.customvalidators.NotDuplicateTargetName;
import java.lang.annotation.Annotation;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.glassfish.api.admin.config.Named;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;

public class NotDuplicateTargetNameValidator
implements ConstraintValidator<NotDuplicateTargetName, Named> {
    Domain domain = null;

    @Override
    public void initialize(NotDuplicateTargetName constraintAnnotation) {
        ServiceLocator locator = ServiceLocatorFactory.getInstance().find("default");
        if (locator == null) {
            return;
        }
        ConfigBeansUtilities cbu = locator.getService(ConfigBeansUtilities.class, new Annotation[0]);
        if (cbu == null) {
            return;
        }
        this.domain = cbu.getDomain();
    }

    @Override
    public boolean isValid(Named bean, ConstraintValidatorContext context) {
        boolean checkCluster = true;
        boolean checkConfig = true;
        boolean checkNode = true;
        boolean checkServer = true;
        if (bean instanceof Server) {
            checkServer = false;
        } else if (bean instanceof Cluster) {
            checkCluster = false;
        } else if (bean instanceof Config) {
            checkConfig = false;
        } else if (bean instanceof Node) {
            checkNode = false;
        }
        String name = bean.getName();
        if (this.domain == null) {
            return true;
        }
        return !(checkCluster && this.domain.getClusterNamed(name) != null || checkConfig && this.domain.getConfigNamed(name) != null || checkNode && this.domain.getNodeNamed(name) != null) && (!checkServer || this.domain.getServerNamed(name) == null);
    }
}

