/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.BeanDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
public class ConnectorJavaBeanValidator {
    private static final Logger _logger = LogDomains.getLogger(ConnectorJavaBeanValidator.class, "javax.enterprise.resource.resourceadapter");

    public void validateJavaBean(Object bean, String rarName) {
        if (bean != null) {
            Validator validator = this.getBeanValidator(rarName);
            if (validator != null) {
                BeanDescriptor bd = validator.getConstraintsForClass(bean.getClass());
                bd.getConstraintDescriptors();
                Class[] array = new Class[]{};
                Set<ConstraintViolation<Object>> constraintViolations = validator.validate(bean, array);
                if (constraintViolations != null && constraintViolations.size() > 0) {
                    ConstraintViolationException cve = new ConstraintViolationException(constraintViolations);
                    StringBuffer msg = new StringBuffer();
                    for (ConstraintViolation<Object> cv : constraintViolations) {
                        msg.append("\n Bean Class : ").append(cv.getRootBeanClass());
                        msg.append("\n Bean : ").append(cv.getRootBean());
                        msg.append("\n Property path : ").append(cv.getPropertyPath());
                        msg.append("\n Violation Message : ").append(cv.getMessage());
                    }
                    Object[] args = new Object[]{bean.getClass(), rarName, msg.toString()};
                    _logger.log(Level.SEVERE, "validation.constraints.violation", args);
                    throw cve;
                }
            } else if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "No Bean Validator is available for RAR [ " + rarName + " ]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Validator getBeanValidator(String rarName) {
        Validator beanValidator = ConnectorRegistry.getInstance().getBeanValidator(rarName);
        ValidatorFactory validatorFactory = null;
        if (beanValidator == null) {
            ClassLoader contextCL = null;
            try {
                contextCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(ConnectorRuntime.getRuntime().getConnectorClassLoader());
                validatorFactory = Validation.byDefaultProvider().configure().buildValidatorFactory();
                beanValidator = validatorFactory.getValidator();
                ConnectorRegistry.getInstance().addBeanValidator(rarName, beanValidator);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextCL);
            }
        }
        return beanValidator;
    }
}

