/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.JndiEnvironmentRefsGroupDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class InterceptorDescriptor
extends JndiEnvironmentRefsGroupDescriptor {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InterceptorDescriptor.class);
    private static final Logger _logger = DOLUtils.getDefaultLogger();
    private Set<LifecycleCallbackDescriptor> aroundInvokeDescriptors;
    private Set<LifecycleCallbackDescriptor> aroundTimeoutDescriptors;
    private String interceptorClassName;
    private Class interceptorClass;
    private boolean fromBeanClass = false;

    public String getInterceptorClassName() {
        return this.interceptorClassName;
    }

    public void setInterceptorClassName(String className) {
        this.interceptorClassName = className;
    }

    public Class getInterceptorClass() {
        return this.interceptorClass;
    }

    public void setInterceptorClass(Class c) {
        this.interceptorClass = c;
        this.setInterceptorClassName(c.getName());
    }

    public Set<LifecycleCallbackDescriptor> getAroundInvokeDescriptors() {
        if (this.aroundInvokeDescriptors == null) {
            this.aroundInvokeDescriptors = new HashSet<LifecycleCallbackDescriptor>();
        }
        return this.aroundInvokeDescriptors;
    }

    public List<LifecycleCallbackDescriptor> getOrderedAroundInvokeDescriptors(ClassLoader loader) throws Exception {
        return this.orderDescriptors(this.getAroundInvokeDescriptors(), loader);
    }

    public Set<LifecycleCallbackDescriptor> getAroundTimeoutDescriptors() {
        if (this.aroundTimeoutDescriptors == null) {
            this.aroundTimeoutDescriptors = new HashSet<LifecycleCallbackDescriptor>();
        }
        return this.aroundTimeoutDescriptors;
    }

    public List<LifecycleCallbackDescriptor> getOrderedAroundTimeoutDescriptors(ClassLoader loader) throws Exception {
        return this.orderDescriptors(this.getAroundTimeoutDescriptors(), loader);
    }

    public void setFromBeanClass(boolean flag) {
        this.fromBeanClass = flag;
    }

    public boolean getFromBeanClass() {
        return this.fromBeanClass;
    }

    public void addAroundInvokeDescriptor(LifecycleCallbackDescriptor aroundInvokeDesc) {
        Set<LifecycleCallbackDescriptor> aroundInvokeDescs = this.getAroundInvokeDescriptors();
        if (!this.knownLifecycleCallbackDescriptor(aroundInvokeDesc, aroundInvokeDescs)) {
            aroundInvokeDescs.add(aroundInvokeDesc);
        }
    }

    public void addAroundInvokeDescriptors(Set<LifecycleCallbackDescriptor> aroundInvokes) {
        for (LifecycleCallbackDescriptor ai : aroundInvokes) {
            this.addAroundInvokeDescriptor(ai);
        }
    }

    public boolean hasAroundInvokeDescriptor() {
        return this.getAroundInvokeDescriptors().size() > 0;
    }

    public void addAroundTimeoutDescriptor(LifecycleCallbackDescriptor aroundTimeoutDesc) {
        Set<LifecycleCallbackDescriptor> aroundTimeoutDescs = this.getAroundTimeoutDescriptors();
        if (!this.knownLifecycleCallbackDescriptor(aroundTimeoutDesc, aroundTimeoutDescs)) {
            aroundTimeoutDescs.add(aroundTimeoutDesc);
        }
    }

    private boolean knownLifecycleCallbackDescriptor(LifecycleCallbackDescriptor desc, Set<LifecycleCallbackDescriptor> descs) {
        boolean found = false;
        for (LifecycleCallbackDescriptor ai : descs) {
            if (desc.getLifecycleCallbackClass() == null || !desc.getLifecycleCallbackClass().equals(ai.getLifecycleCallbackClass())) continue;
            found = true;
        }
        return found;
    }

    public void addAroundTimeoutDescriptors(Set<LifecycleCallbackDescriptor> aroundTimeouts) {
        for (LifecycleCallbackDescriptor ai : aroundTimeouts) {
            this.addAroundTimeoutDescriptor(ai);
        }
    }

    public boolean hasAroundTimeoutDescriptor() {
        return this.getAroundTimeoutDescriptors().size() > 0;
    }

    public List<LifecycleCallbackDescriptor> getOrderedCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType type2, ClassLoader loader) throws Exception {
        return this.orderDescriptors(this.getCallbackDescriptors(type2), loader);
    }

    public void addAroundConstructDescriptor(LifecycleCallbackDescriptor lcDesc) {
        this.addCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT, lcDesc);
    }

    public void addPostActivateDescriptor(LifecycleCallbackDescriptor lcDesc) {
        this.addCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE, lcDesc);
    }

    public void addPrePassivateDescriptor(LifecycleCallbackDescriptor lcDesc) {
        this.addCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE, lcDesc);
    }

    private List<LifecycleCallbackDescriptor> orderDescriptors(Set<LifecycleCallbackDescriptor> lcds, ClassLoader loader) throws Exception {
        LinkedList<LifecycleCallbackDescriptor> orderedDescs = new LinkedList<LifecycleCallbackDescriptor>();
        HashMap<String, LifecycleCallbackDescriptor> map = new HashMap<String, LifecycleCallbackDescriptor>();
        for (LifecycleCallbackDescriptor next : lcds) {
            map.put(next.getLifecycleCallbackClass(), next);
        }
        Class<?> nextClass = this.getInterceptorClass();
        if (nextClass == null) {
            nextClass = loader.loadClass(this.getInterceptorClassName());
        }
        while (nextClass != Object.class && nextClass != null) {
            String nextClassName = nextClass.getName();
            if (map.containsKey(nextClassName)) {
                LifecycleCallbackDescriptor lcd = (LifecycleCallbackDescriptor)map.get(nextClassName);
                orderedDescs.addFirst(lcd);
            }
            nextClass = nextClass.getSuperclass();
        }
        return orderedDescs;
    }

    @Override
    public String toString() {
        return "InterceptorDescriptor class = " + this.getInterceptorClassName();
    }
}

