/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.listener;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.listener.ConnectionEventListener;
import com.sun.enterprise.resource.pool.PoolManager;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ManagedConnection;

public class LocalTxConnectionEventListener
extends ConnectionEventListener {
    private PoolManager poolMgr;
    private IdentityHashMap associatedHandles;
    private ResourceHandle resource;

    public LocalTxConnectionEventListener(ResourceHandle resource) {
        this.resource = resource;
        this.associatedHandles = new IdentityHashMap(10);
        this.poolMgr = ConnectorRuntime.getRuntime().getPoolManager();
    }

    @Override
    public void connectionClosed(ConnectionEvent evt) {
        Object connectionHandle = evt.getConnectionHandle();
        ResourceHandle handle = this.resource;
        if (this.associatedHandles.containsKey(connectionHandle)) {
            handle = (ResourceHandle)this.associatedHandles.get(connectionHandle);
        }
        this.poolMgr.resourceClosed(handle);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent evt) {
        this.resource.setConnectionErrorOccurred();
        ManagedConnection mc = (ManagedConnection)evt.getSource();
        mc.removeConnectionEventListener(this);
        this.poolMgr.resourceErrorOccurred(this.resource);
    }

    @Override
    public void badConnectionClosed(ConnectionEvent evt) {
        Object connectionHandle = evt.getConnectionHandle();
        ResourceHandle handle = this.resource;
        if (this.associatedHandles.containsKey(connectionHandle)) {
            handle = (ResourceHandle)this.associatedHandles.get(connectionHandle);
        }
        ManagedConnection mc = (ManagedConnection)evt.getSource();
        mc.removeConnectionEventListener(this);
        this.poolMgr.badResourceClosed(handle);
    }

    @Override
    public void localTransactionStarted(ConnectionEvent evt) {
    }

    @Override
    public void localTransactionCommitted(ConnectionEvent evt) {
    }

    @Override
    public void localTransactionRolledback(ConnectionEvent evt) {
    }

    public void associateHandle(Object c, ResourceHandle h) {
        this.associatedHandles.put(c, h);
    }

    public ResourceHandle removeAssociation(Object c) {
        return (ResourceHandle)this.associatedHandles.remove(c);
    }

    public Map getAssociatedHandles() {
        return this.associatedHandles;
    }
}

