/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.security.store.DomainScopedPasswordAliasStore;
import com.sun.enterprise.util.LocalStringManagerImpl;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="delete-password-alias")
@PerLookup
@I18n(value="delete.password.alias")
@ExecuteOn(value={RuntimeType.ALL})
@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="delete-password-alias", description="delete-password-alias")})
@AccessRequired(resource={"domain/passwordAliases/passwordAlias/$aliasName"}, action={"delete"})
public class DeletePasswordAlias
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeletePasswordAlias.class);
    @Param(name="aliasname", primary=true)
    private String aliasName;
    @Inject
    private DomainScopedPasswordAliasStore domainPasswordAliasStore;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            if (!this.domainPasswordAliasStore.containsKey(this.aliasName)) {
                report.setMessage(localStrings.getLocalString("delete.password.alias.notfound", "Password alias for the alias {0} does not exist.", this.aliasName));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return false;
            }
        }
        catch (Exception ex) {
            this.reportFailure(context.getActionReport(), ex);
            return false;
        }
        return true;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            this.domainPasswordAliasStore.remove(this.aliasName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.reportFailure(report, ex);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void reportFailure(ActionReport report, Exception ex) {
        report.setMessage(localStrings.getLocalString("delete.password.alias.fail", "Deletion of Password Alias {0} failed", this.aliasName));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        report.setFailureCause(ex);
    }
}

