/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.AppCNonceCacheMap;
import com.sun.enterprise.security.CNonceCacheFactory;
import com.sun.enterprise.security.EjbSecurityPolicyProbeProvider;
import com.sun.enterprise.security.WebSecurityDeployerProbeProvider;
import com.sun.enterprise.security.ee.SecurityContainer;
import com.sun.enterprise.security.ee.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DummyApplication;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.security.common.CNonceCache;
import org.glassfish.security.common.HAUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="Security")
public class SecurityDeployer
extends SimpleDeployer<SecurityContainer, DummyApplication>
implements PostConstruct {
    private static final Logger _logger = LogDomains.getLogger(SecurityDeployer.class, "javax.enterprise.system.core.security");
    @Inject
    private ServerContext serverContext;
    @Inject
    @Named(value="webSecurityCIH")
    private Provider<RegisteredComponentInvocationHandler> registeredComponentInvocationHandlerProvider;
    @Inject
    private Provider<Events> eventsProvider;
    @Inject
    private Provider<HAUtil> haUtilProvider;
    @Inject
    private Provider<AppCNonceCacheMap> appCNonceCacheMapProvider;
    @Inject
    private Provider<CNonceCacheFactory> cNonceCacheFactoryProvider;
    @Inject
    private WebSecurityManagerFactory wsmf;
    private AppCNonceCacheMap appCnonceMap;
    private HAUtil haUtil;
    private CNonceCacheFactory cnonceCacheFactory;
    private static final String HA_CNONCE_BS_NAME = "HA-CNonceCache-Backingstore";
    private EventListener listener = null;
    private static WebSecurityDeployerProbeProvider websecurityProbeProvider = new WebSecurityDeployerProbeProvider();
    private static EjbSecurityPolicyProbeProvider ejbProbeProvider = new EjbSecurityPolicyProbeProvider();

    @Override
    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin.isArtifactsPresent()) {
            return;
        }
        String appName = params.name();
        try {
            Application app = dc.getModuleMetaData(Application.class);
            Set<WebBundleDescriptor> webDesc = app.getBundleDescriptors(WebBundleDescriptor.class);
            if (webDesc == null) {
                return;
            }
            for (WebBundleDescriptor webBD : webDesc) {
                this.loadPolicy(webBD, false);
            }
        }
        catch (Exception se) {
            String msg = "Error in generating security policy for " + appName;
            throw new DeploymentException(msg, se);
        }
    }

    @Override
    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
        CNonceCache cache;
        this.removePolicy(dc);
        SecurityUtil.removeRoleMapper(dc);
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (this.appCnonceMap != null && (cache = (CNonceCache)this.appCnonceMap.remove(params.name())) != null) {
            cache.destroy();
        }
    }

    @Override
    public DummyApplication load(SecurityContainer container, DeploymentContext context) {
        DeployCommandParameters dparams = context.getCommandParameters(DeployCommandParameters.class);
        Application app = context.getModuleMetaData(Application.class);
        this.handleCNonceCacheBSInit(app.getAppName(), app.getBundleDescriptors(WebBundleDescriptor.class), dparams.availabilityenabled);
        return new DummyApplication();
    }

    @Override
    public void unload(DummyApplication container, DeploymentContext context) {
        OpsParams params = context.getCommandParameters(OpsParams.class);
        this.cleanSecurityContext(params.name());
    }

    private void loadPolicy(WebBundleDescriptor webBD, boolean remove) throws DeploymentException {
        try {
            if (webBD != null) {
                String cid;
                WebSecurityManager wsm;
                if (remove && (wsm = this.wsmf.getManager(cid = SecurityUtil.getContextID(webBD), null, true)) != null) {
                    wsm.release();
                }
                this.wsmf.createManager(webBD, true, this.serverContext);
            }
        }
        catch (Exception se) {
            String msg = "Error in generating security policy for " + webBD.getModuleDescriptor().getModuleName();
            throw new DeploymentException(msg, se);
        }
    }

    private void commitPolicy(WebBundleDescriptor webBD) throws DeploymentException {
        try {
            if (webBD != null) {
                if (webBD.isPolicyModified()) {
                    this.loadPolicy(webBD, true);
                }
                String cid = SecurityUtil.getContextID(webBD);
                websecurityProbeProvider.policyCreationStartedEvent(cid);
                SecurityUtil.generatePolicyFile(cid);
                websecurityProbeProvider.policyCreationEndedEvent(cid);
                websecurityProbeProvider.policyCreationEvent(cid);
            }
        }
        catch (Exception se) {
            String msg = "Error in generating security policy for " + webBD.getModuleDescriptor().getModuleName();
            throw new DeploymentException(msg, se);
        }
    }

    private void commitEjbs(Application app) throws DeploymentException {
        Set<EjbBundleDescriptor> ejbDescriptors = app.getBundleDescriptors(EjbBundleDescriptor.class);
        try {
            for (EjbBundleDescriptor ejbBD : ejbDescriptors) {
                String pcid = SecurityUtil.getContextID(ejbBD);
                ejbProbeProvider.policyCreationStartedEvent(pcid);
                SecurityUtil.generatePolicyFile(pcid);
                ejbProbeProvider.policyCreationEndedEvent(pcid);
                ejbProbeProvider.policyCreationEvent(pcid);
            }
        }
        catch (Exception se) {
            String msg = "Error in committing security policy for ejbs of " + app.getRegistrationName();
            throw new DeploymentException(msg, se);
        }
    }

    private void linkPolicies(Application app, Collection<WebBundleDescriptor> webs) throws DeploymentException {
        try {
            String linkName = null;
            boolean lastInService = false;
            for (WebBundleDescriptor wbd : webs) {
                String name = SecurityUtil.getContextID(wbd);
                lastInService = SecurityUtil.linkPolicyFile(name, linkName, lastInService);
                linkName = name;
            }
            Set<EjbBundleDescriptor> ejbs = app.getBundleDescriptors(EjbBundleDescriptor.class);
            for (EjbBundleDescriptor ejbd : ejbs) {
                String name = SecurityUtil.getContextID(ejbd);
                lastInService = SecurityUtil.linkPolicyFile(name, linkName, lastInService);
                linkName = name;
            }
        }
        catch (IASSecurityException se) {
            String msg = "Error in linking security policy for " + app.getRegistrationName();
            throw new DeploymentException(msg, se);
        }
    }

    private void removePolicy(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (!params.origin.needsCleanArtifacts()) {
            return;
        }
        String appName = params.name();
        try {
            String[] webcontexts = this.wsmf.getContextsForApp(appName, false);
            if (webcontexts != null) {
                for (int i = 0; i < webcontexts.length; ++i) {
                    if (webcontexts[i] == null) continue;
                    websecurityProbeProvider.policyDestructionStartedEvent(webcontexts[i]);
                    SecurityUtil.removePolicy(webcontexts[i]);
                    websecurityProbeProvider.policyDestructionEndedEvent(webcontexts[i]);
                    websecurityProbeProvider.policyDestructionEvent(webcontexts[i]);
                }
            }
        }
        catch (IASSecurityException ex) {
            String msg = "Error in removing security policy for " + appName;
            _logger.log(Level.WARNING, msg, ex);
            throw new DeploymentException(msg, ex);
        }
        this.cleanSecurityContext(appName);
    }

    @Override
    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    private boolean cleanSecurityContext(String appName) {
        boolean cleanUpDone = false;
        ArrayList<WebSecurityManager> managers = this.wsmf.getManagersForApp(appName, false);
        for (int i = 0; managers != null && i < managers.size(); ++i) {
            try {
                websecurityProbeProvider.securityManagerDestructionStartedEvent(appName);
                managers.get(i).destroy();
                websecurityProbeProvider.securityManagerDestructionEndedEvent(appName);
                websecurityProbeProvider.securityManagerDestructionEvent(appName);
                cleanUpDone = true;
                continue;
            }
            catch (Exception pce) {
                _logger.log(Level.WARNING, "Unable to destroy WebSecurityManager", pce);
            }
        }
        return cleanUpDone;
    }

    public static List<EventTypes> getDeploymentEvents() {
        ArrayList<EventTypes> events = new ArrayList<EventTypes>();
        events.add(Deployment.APPLICATION_PREPARED);
        return events;
    }

    @Override
    public void postConstruct() {
        this.listener = new AppDeployEventListener();
        Events events = this.eventsProvider.get();
        events.register(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHaEnabled() {
        boolean haEnabled = false;
        SecurityDeployer securityDeployer = this;
        synchronized (securityDeployer) {
            if (this.haUtil == null) {
                this.haUtil = this.haUtilProvider.get();
            }
        }
        if (this.haUtil != null && this.haUtil.isHAEnabled()) {
            haEnabled = true;
            securityDeployer = this;
            synchronized (securityDeployer) {
                if (this.appCnonceMap == null) {
                    this.appCnonceMap = this.appCNonceCacheMapProvider.get();
                }
                if (this.cnonceCacheFactory == null) {
                    this.cnonceCacheFactory = this.cNonceCacheFactoryProvider.get();
                }
            }
        }
        return haEnabled;
    }

    private void handleCNonceCacheBSInit(String appName, Set<WebBundleDescriptor> webDesc, boolean isHA) {
        boolean hasDigest = false;
        for (WebBundleDescriptor webBD : webDesc) {
            LoginConfiguration lc = webBD.getLoginConfiguration();
            if (lc == null || !"DIGEST".equals(lc.getAuthenticationMethod())) continue;
            hasDigest = true;
            break;
        }
        if (!hasDigest) {
            return;
        }
        if (this.isHaEnabled() && isHA) {
            String clusterName = this.haUtil.getClusterName();
            String instanceName = this.haUtil.getInstanceName();
            if (this.cnonceCacheFactory != null) {
                CNonceCache cache = this.cnonceCacheFactory.createCNonceCache(appName, clusterName, instanceName, HA_CNONCE_BS_NAME);
                this.appCnonceMap.put(appName, cache);
            }
        }
    }

    private class AppDeployEventListener
    implements EventListener {
        private AppDeployEventListener() {
        }

        @Override
        public void event(EventListener.Event event) {
            Application app = null;
            if (Deployment.MODULE_LOADED.equals(event.type())) {
                ModuleInfo moduleInfo = (ModuleInfo)event.hook();
                if (moduleInfo instanceof ApplicationInfo) {
                    return;
                }
                WebBundleDescriptor webBD = (WebBundleDescriptor)moduleInfo.getMetaData("org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl");
                SecurityDeployer.this.loadPolicy(webBD, false);
            } else if (Deployment.APPLICATION_LOADED.equals(event.type())) {
                RegisteredComponentInvocationHandler handler;
                ApplicationInfo appInfo = (ApplicationInfo)event.hook();
                app = appInfo.getMetaData(Application.class);
                if (app == null) {
                    return;
                }
                Set<WebBundleDescriptor> webDesc = app.getBundleDescriptors(WebBundleDescriptor.class);
                SecurityDeployer.this.linkPolicies(app, webDesc);
                SecurityDeployer.this.commitEjbs(app);
                if (webDesc != null && !webDesc.isEmpty() && (handler = (RegisteredComponentInvocationHandler)SecurityDeployer.this.registeredComponentInvocationHandlerProvider.get()) != null) {
                    handler.register();
                }
            } else if (WebBundleDescriptor.AFTER_SERVLET_CONTEXT_INITIALIZED_EVENT.equals(event.type())) {
                SecurityDeployer.this.commitPolicy((WebBundleDescriptor)event.hook());
            }
        }
    }
}

