/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.admin.commands.StringBuilderNewLineAppender;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MBeanServerConnection;

class SummaryReporter {
    private final MBeanServerConnection mbsc;
    private final StringManager sm = StringManager.getManager(SummaryReporter.class);
    private static final String secretProperty = "module.core.status";

    public SummaryReporter(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
    }

    public String getSummaryReport() throws RuntimeException {
        try {
            StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
            OperatingSystemMXBean os = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
            sb.append(this.getOSInfo(os));
            RuntimeMXBean rt = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=Runtime", RuntimeMXBean.class);
            sb.append(this.getArguments(rt));
            sb.append(this.getVMInfo(rt));
            return sb.toString(secretProperty);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getOSInfo(OperatingSystemMXBean os) {
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        sb.append(this.sm.getString("os.info"));
        sb.append(this.sm.getString("os.name", os.getName()));
        sb.append(this.sm.getString("os.arch", os.getArch(), os.getVersion()));
        sb.append(this.sm.getString("os.nproc", os.getAvailableProcessors()));
        sb.append(this.sm.getString("os.load", this.getSystemLoad(os)));
        return sb.toString();
    }

    private String getVMInfo(RuntimeMXBean rt) {
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        sb.append(this.sm.getString("rt.info", rt.getName()));
        sb.append(this.sm.getString("rt.bcp", rt.getBootClassPath()));
        sb.append(this.sm.getString("rt.cp", rt.getClassPath()));
        sb.append(this.sm.getString("rt.libpath", rt.getLibraryPath()));
        sb.append(this.sm.getString("rt.nvv", rt.getVmName(), rt.getVmVendor(), rt.getVmVersion()));
        sb.append(this.getProperties(rt));
        return sb.toString();
    }

    private String getProperties(RuntimeMXBean rt) {
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        Map<String, String> unsorted = rt.getSystemProperties();
        TreeMap<String, String> props = new TreeMap<String, String>(unsorted);
        sb.append("");
        sb.append(this.sm.getString("rt.sysprops"));
        for (Map.Entry<String, String> entry : props.entrySet()) {
            sb.append(entry.getKey() + " = " + this.filterForbidden(entry.getKey(), entry.getValue()));
        }
        return sb.toString();
    }

    private String getSystemLoad(OperatingSystemMXBean os) {
        String info = "NOT_AVAILABLE";
        try {
            String METHOD = "getSystemLoadAverage";
            Method m = os.getClass().getMethod(METHOD, null);
            if (m != null) {
                Object ret = m.invoke((Object)os, (Object[])null);
                return ret.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    private String filterForbidden(String key, String value) {
        if (StringUtils.ok(key) && key.startsWith("javax.net.ssl.") && key.indexOf("password") >= 0) {
            return "********";
        }
        return value;
    }

    private String getArguments(RuntimeMXBean rt) {
        StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
        List<String> arguments = rt.getInputArguments();
        if (arguments.size() > 0) {
            sb.append(this.sm.getString("rt.arguments"));
            for (String argument : arguments) {
                sb.append(argument);
            }
        }
        return sb.toString();
    }
}

