/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.hk2.api.Factory;
import org.jvnet.hk2.annotations.Service;

@Service
public class ExecutorServiceFactory
implements Factory<ExecutorService> {
    private ExecutorService service;
    private AtomicInteger count = new AtomicInteger(1);

    @Override
    public ExecutorService provide() {
        if (this.service == null) {
            this.service = Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    t.setName("Executor-Service-" + ExecutorServiceFactory.this.count.getAndIncrement());
                    t.setContextClassLoader(null);
                    return t;
                }
            });
        }
        return this.service;
    }

    @Override
    public void dispose(ExecutorService instance) {
    }
}

