/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.http.server.util.AlternateDocBase;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;

public class ADBAwareHttpHandler
extends StaticHttpHandler {
    private static final Logger LOGGER = Grizzly.logger(ADBAwareHttpHandler.class);
    private final List<AlternateDocBase> alternateDocBases = new ArrayList<AlternateDocBase>();

    public ADBAwareHttpHandler() {
        super((Set<String>)null);
    }

    public void addAlternateDocBase(String urlPattern, String docBase) {
        if (urlPattern == null) {
            throw new IllegalArgumentException("The urlPattern argument can't be null");
        }
        if (docBase == null) {
            throw new IllegalArgumentException("The docBase argument can't be null");
        }
        AlternateDocBase alternateDocBase = new AlternateDocBase();
        alternateDocBase.setUrlPattern(urlPattern);
        alternateDocBase.setDocBase(docBase);
        alternateDocBase.setBasePath(this.getBasePath(docBase));
        this.alternateDocBases.add(alternateDocBase);
    }

    @Override
    protected boolean handle(String uri, Request request, Response response) throws Exception {
        File file = this.lookupInADB(uri);
        if (file != null) {
            this.serveFile(file, request, response);
            return true;
        }
        return super.handle(uri, request, response);
    }

    private String getBasePath(String docBase) {
        return new File(docBase).getAbsolutePath();
    }

    private void serveFile(File file, Request request, Response response) throws IOException {
        if (!Method.GET.equals(request.getMethod())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "File found {0}, but HTTP method {1} is not allowed", new Object[]{file, request.getMethod()});
            }
            response.setStatus(HttpStatus.METHOD_NOT_ALLOWED_405);
            response.setHeader(Header.Allow, "GET");
            return;
        }
        ADBAwareHttpHandler.pickupContentType(response, file.getPath());
        this.addToFileCache(request, response, file);
        ADBAwareHttpHandler.sendFile(response, file);
    }

    private File lookupInADB(String uri) {
        AlternateDocBase adb = AlternateDocBase.findMatch(uri, this.alternateDocBases);
        if (adb != null) {
            File file = new File(adb.getBasePath(), uri);
            boolean exists = file.exists();
            boolean isDirectory = file.isDirectory();
            if (exists && isDirectory) {
                file = new File(file, "/index.html");
                exists = file.exists();
                isDirectory = file.isDirectory();
            }
            if (exists && !isDirectory) {
                return file;
            }
        }
        return null;
    }
}

