/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor.stats;

import com.sun.enterprise.v3.services.impl.monitor.stats.StatsProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

@AMXMetadata(type="thread-pool-mon", group="monitoring")
@ManagedObject
@Description(value="Thread Pool Statistics")
public class ThreadPoolStatsProvider
implements StatsProvider {
    private final String name;
    protected final CountStatisticImpl maxThreadsCount = new CountStatisticImpl("MaxThreads", "count", "Maximum number of threads allowed in the thread pool");
    protected final CountStatisticImpl coreThreadsCount = new CountStatisticImpl("CoreThreads", "count", "Core number of threads in the thread pool");
    protected final CountStatisticImpl totalExecutedTasksCount = new CountStatisticImpl("TotalExecutedTasksCount", "count", "Provides the total number of tasks, which were executed by the thread pool");
    protected final CountStatisticImpl currentThreadCount = new CountStatisticImpl("CurrentThreadCount", "count", "Provides the number of request processing threads currently in the listener thread pool");
    protected final CountStatisticImpl currentThreadsBusy = new CountStatisticImpl("CurrentThreadsBusy", "count", "Provides the number of request processing threads currently in use in the listener thread pool serving requests");
    protected volatile ThreadPoolConfig threadPoolConfig;
    protected static volatile List<String> threadPoolNames = new ArrayList<String>();

    public ThreadPoolStatsProvider(String name) {
        this.name = name;
    }

    @Override
    public Object getStatsObject() {
        return this.threadPoolConfig;
    }

    @Override
    public void setStatsObject(Object object) {
        if (object instanceof ThreadPoolConfig) {
            this.threadPoolConfig = (ThreadPoolConfig)object;
            if (!this.threadPoolConfig.getPoolName().equals("")) {
                threadPoolNames.add(this.threadPoolConfig.getPoolName());
            }
        } else {
            this.threadPoolConfig = null;
        }
    }

    @ManagedAttribute(id="maxthreads")
    @Description(value="Maximum number of threads allowed in the thread pool")
    public CountStatistic getMaxThreadsCount() {
        return this.maxThreadsCount;
    }

    @ManagedAttribute(id="corethreads")
    @Description(value="Core number of threads in the thread pool")
    public CountStatistic getCoreThreadsCount() {
        return this.coreThreadsCount;
    }

    @ManagedAttribute(id="totalexecutedtasks")
    @Description(value="Provides the total number of tasks, which were executed by the thread pool")
    public CountStatistic getTotalExecutedTasksCount() {
        return this.totalExecutedTasksCount;
    }

    @ManagedAttribute(id="currentthreadcount")
    @Description(value="Provides the number of request processing threads currently in the listener thread pool")
    public CountStatistic getCurrentThreadCount() {
        if (this.threadPoolConfig != null) {
            this.countThreadsInThreadPool(this.threadPoolConfig.getPoolName());
        }
        return this.currentThreadCount;
    }

    @ManagedAttribute(id="currentthreadsbusy")
    @Description(value="Provides the number of request processing threads currently in use in the listener thread pool serving requests.")
    public CountStatistic getCurrentThreadsBusy() {
        if (this.threadPoolConfig != null) {
            this.countThreadsInThreadPool(this.threadPoolConfig.getPoolName());
        }
        return this.currentThreadsBusy;
    }

    @ProbeListener(value="glassfish:kernel:thread-pool:setMaxThreadsEvent")
    public void setMaxThreadsEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="maxNumberOfThreads") int maxNumberOfThreads) {
        if (this.name.equals(monitoringId)) {
            this.maxThreadsCount.setCount(maxNumberOfThreads);
        }
    }

    @ProbeListener(value="glassfish:kernel:thread-pool:setCoreThreadsEvent")
    public void setCoreThreadsEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="coreNumberOfThreads") int coreNumberOfThreads) {
        if (this.name.equals(monitoringId)) {
            this.coreThreadsCount.setCount(coreNumberOfThreads);
        }
    }

    @ProbeListener(value="glassfish:kernel:thread-pool:threadReturnedToPoolEvent")
    public void threadReturnedToPoolEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="threadId") long threadId) {
        if (this.name.equals(monitoringId)) {
            this.totalExecutedTasksCount.increment();
        }
    }

    @Reset
    public void reset() {
        if (this.threadPoolConfig != null) {
            this.maxThreadsCount.setCount(this.threadPoolConfig.getMaxPoolSize());
            this.coreThreadsCount.setCount(this.threadPoolConfig.getCorePoolSize());
        }
        this.totalExecutedTasksCount.setCount(0L);
    }

    private void countThreadsInThreadPool(String threadPoolName) {
        this.currentThreadCount.setCount(0L);
        this.currentThreadsBusy.setCount(0L);
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        ArrayList<String> alreadyCounted = new ArrayList<String>();
        for (Thread thread : threads) {
            String threadName = thread.getName();
            if (!thread.isAlive() || !threadName.contains(threadPoolName + "(") || alreadyCounted.contains(threadName)) continue;
            alreadyCounted.add(threadName);
            this.currentThreadCount.increment();
            if (thread.getState() != Thread.State.RUNNABLE) continue;
            this.currentThreadsBusy.increment();
        }
    }
}

