/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.trace;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CurrentTransaction;
import com.sun.jts.CosTransactions.TopCoordinator;
import com.sun.jts.trace.InvalidTraceLevelException;
import com.sun.jts.trace.TraceRecordFormatter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;

public class TraceUtil {
    private static int m_currentTraceLevel = 0;
    private static char m_fieldDelimiter = (char)58;
    private static String m_traceRecordTag = "iAS_JTS_Trace> ";
    private static PrintWriter m_traceWriter = null;

    public static void init(PrintWriter traceWriter) {
        TraceUtil.setTraceWriter(traceWriter);
    }

    public static void setTraceWriter(PrintWriter traceWriter) {
        m_traceWriter = traceWriter;
    }

    public static PrintWriter getTraceWriter() {
        return m_traceWriter;
    }

    public static int getCurrentTraceLevel() {
        return m_currentTraceLevel;
    }

    public static void setCurrentTraceLevel(int traceLevel) throws InvalidTraceLevelException {
        if (Configuration.isTraceEnabled()) {
            boolean traceLevelSet = false;
            for (int i = 0; i <= 6; ++i) {
                if (traceLevel != i) continue;
                m_currentTraceLevel = traceLevel;
                traceLevelSet = true;
                break;
            }
            if (!traceLevelSet) {
                throw new InvalidTraceLevelException();
            }
        }
    }

    public static void print(int traceLevel, PrintWriter outWriter, Object tid, Object origin, String msg) {
        if (traceLevel <= m_currentTraceLevel) {
            String traceRecord = TraceRecordFormatter.createTraceRecord(tid, origin, msg);
            outWriter.println(traceRecord);
        }
    }

    public static void print(int traceLevel, Object origin, String msg) {
        try {
            TraceUtil.print(traceLevel, ((TopCoordinator)CurrentTransaction.getCurrent().get_localCoordinator()).get_transaction_name(), origin, msg);
        }
        catch (Exception e) {
            TraceUtil.print(traceLevel, null, origin, msg);
        }
    }

    public static void print(int traceLevel, Object tid, Object origin, String msg) {
        TraceUtil.print(traceLevel, m_traceWriter, tid, origin, msg);
    }

    public static char getFieldDelimiter() {
        return m_fieldDelimiter;
    }

    public static void setFieldDelimiter(char delimiter) {
        m_fieldDelimiter = delimiter;
    }

    public static String getTraceRecordTag() {
        return m_traceRecordTag;
    }

    public static void setTraceRecordTag(String traceRecordTag) {
        m_traceRecordTag = traceRecordTag;
    }

    public static String getXAExceptionInfo(XAException exception, Logger logger2) {
        Class<?> aClass = exception.getClass();
        if (aClass.getName().indexOf("OracleXAException") < 0) {
            return exception.getMessage();
        }
        StringBuffer msg = new StringBuffer();
        try {
            String oracleError = "" + TraceUtil.invokeMethod(exception, aClass, "getOracleError", logger2);
            String oracleSQLError = "" + TraceUtil.invokeMethod(exception, aClass, "getOracleSQLError", logger2);
            String xaError = "" + TraceUtil.invokeMethod(exception, aClass, "getXAError", logger2);
            msg.append("\n XAException = ").append(exception.getMessage()).append("\n OracleError = ").append(oracleError).append("\n OracleSQLError = ").append(oracleSQLError).append("\n XAError = ").append(xaError);
        }
        catch (Exception e) {
            logger2.log(Level.WARNING, "getXAExceptionInfo failed with exception:", e);
        }
        return msg.toString();
    }

    private static Object invokeMethod(Object instance, Class clz, String mname, Logger logger2) {
        try {
            Method m = clz.getMethod(mname, null);
            return m.invoke(instance, null);
        }
        catch (Exception e) {
            logger2.log(Level.FINE, "", e);
            return null;
        }
    }

    static {
        m_traceWriter = new PrintWriter(System.out);
    }
}

