/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.notification.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@Service(name="set-notification-configuration")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="set.notification.configuration")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-notification-configuration", description="Set notification Services Configuration")})
public class SetNotificationConfiguration
implements AdminCommand {
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="dynamic", optional=true, defaultValue="false")
    protected Boolean dynamic;
    @Param(name="notifierDynamic", optional=true, defaultValue="false")
    protected Boolean notifierDynamic;
    @Param(name="notifierEnabled", optional=false)
    private Boolean notifierEnabled;
    @Param(name="notifierName", optional=true, defaultValue="service-log")
    private String notifierName;
    @Inject
    ServiceLocator serviceLocator;
    CommandRunner.CommandInvocation inv;

    @Override
    public void execute(AdminCommandContext context) {
        AdminCommandContext theContext = context;
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if (this.dynamic.booleanValue() || this.enabled.booleanValue()) {
            this.notifierDynamic = this.dynamic != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.notifierEnabled = this.enabled != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        this.enableNotificationConfigureOnTarget(actionReport, theContext, this.enabled);
        this.enableNotificationNotifierConfigurerOnTarget(actionReport, theContext, this.notifierEnabled);
    }

    private void enableNotificationConfigureOnTarget(ActionReport actionReport, AdminCommandContext context, Boolean enabled) {
        CommandRunner runner = this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
        ActionReport subReport = context.getActionReport().addSubActionsReport();
        this.inv = runner.getCommandInvocation("notification-configure", subReport, context.getSubject());
        ParameterMap params = new ParameterMap();
        params.add("enabled", enabled.toString());
        params.add("target", this.target);
        params.add("dynamic", this.dynamic.toString());
        this.inv.parameters(params);
        this.inv.execute();
        if (subReport.hasWarnings()) {
            subReport.setMessage("");
        }
    }

    private void enableNotificationNotifierConfigurerOnTarget(ActionReport actionReport, AdminCommandContext context, Boolean enabled) {
        CommandRunner runner = this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
        ActionReport subReport = context.getActionReport().addSubActionsReport();
        this.inv = runner.getCommandInvocation("notification-configure-notifier", subReport, context.getSubject());
        ParameterMap params = new ParameterMap();
        params.add("dynamic", this.notifierDynamic.toString());
        params.add("target", this.target);
        params.add("notifierName", this.notifierName);
        params.add("notifierEnabled", enabled.toString());
        this.inv.parameters(params);
        this.inv.execute();
        if (subReport.hasWarnings()) {
            subReport.setMessage("");
        }
    }
}

