/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

public class TypeHelperImpl
extends BasicTypeHelperImpl
implements TypeHelper {
    private final AbstractSession session;
    private final ClassLoader classLoader;

    public TypeHelperImpl(AbstractSession session, ClassLoader classLoader) {
        this.session = session;
        this.classLoader = classLoader;
    }

    @Override
    public Object resolveTypeName(String typeName) {
        block5: {
            try {
                if (!PrivilegedAccessHelper.shouldUsePrivilegedAccess()) break block5;
                try {
                    return AccessController.doPrivileged(new PrivilegedClassForName(typeName, true, this.classLoader));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    return null;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getClassForName(typeName, true, this.classLoader);
    }

    @Override
    public Object resolveAttribute(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        if (mapping != null) {
            return this.getType(mapping);
        }
        QueryKey queryKey = this.resolveQueryKey(ownerClass, attribute);
        if (queryKey == null) {
            return null;
        }
        if (queryKey.isForeignReferenceQueryKey()) {
            return ((ForeignReferenceQueryKey)queryKey).getReferenceClass();
        }
        return Object.class;
    }

    @Override
    public Object resolveMapKey(Object ownerClass, String attribute) {
        Object type2 = null;
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        if (mapping.isCollectionMapping()) {
            ContainerPolicy cp = ((CollectionMapping)mapping).getContainerPolicy();
            type2 = cp.getKeyType();
        }
        return type2;
    }

    @Override
    public Object resolveSchema(String schemaName) {
        ClassDescriptor descriptor = this.session.getDescriptorForAlias(schemaName);
        return descriptor != null ? descriptor.getJavaClass() : null;
    }

    @Override
    public Object resolveEnumConstant(Object type2, String constant) {
        Class clazz = this.getJavaClass(type2);
        T[] constants = clazz.getEnumConstants();
        if (constants != null) {
            int i = 0;
            while (i < constants.length) {
                Enum enumConstant = (Enum)constants[i];
                if (enumConstant.name().equals(constant)) {
                    return enumConstant;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public boolean isEntityClass(Object type2) {
        ClassDescriptor desc = this.getDescriptor(type2);
        return desc != null && !desc.isAggregateDescriptor();
    }

    @Override
    public boolean isOrderableType(Object type2) {
        return !this.isEntityClass(type2) && !this.isEmbeddable(type2);
    }

    @Override
    public boolean isEmbeddable(Object type2) {
        ClassDescriptor desc = this.getDescriptor(type2);
        return desc != null && desc.isAggregateDescriptor();
    }

    @Override
    public boolean isEmbeddedAttribute(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && mapping.isAggregateObjectMapping();
    }

    @Override
    public boolean isSimpleStateAttribute(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && mapping.isDirectToFieldMapping();
    }

    @Override
    public boolean isRelationship(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && mapping.isForeignReferenceMapping();
    }

    @Override
    public boolean isSingleValuedRelationship(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && mapping.isObjectReferenceMapping();
    }

    @Override
    public boolean isCollectionValuedRelationship(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && (mapping.isOneToManyMapping() || mapping.isManyToManyMapping());
    }

    private ClassDescriptor getDescriptor(Object type2) {
        ClassDescriptor desc = null;
        if (type2 instanceof Class) {
            desc = this.session.getDescriptor((Class)type2);
        } else if (type2 instanceof ClassDescriptor) {
            desc = (ClassDescriptor)type2;
        }
        return desc;
    }

    private DatabaseMapping resolveAttributeMapping(Object ownerClass, String attribute) {
        ClassDescriptor descriptor = this.getDescriptor(ownerClass);
        return descriptor == null ? null : descriptor.getObjectBuilder().getMappingForAttributeName(attribute);
    }

    @Override
    public QueryKey resolveQueryKey(Object ownerClass, String attribute) {
        ClassDescriptor descriptor = this.getDescriptor(ownerClass);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getQueryKeyNamed(attribute);
    }

    private Object getType(DatabaseMapping mapping) {
        if (mapping == null) {
            return null;
        }
        Object type2 = null;
        if (mapping.isDirectCollectionMapping()) {
            type2 = ((DirectCollectionMapping)mapping).getDirectField().getType();
            if (type2 == null) {
                type2 = Object.class;
            }
        } else {
            ClassDescriptor descriptor;
            type2 = mapping.isAggregateCollectionMapping() ? ((AggregateCollectionMapping)mapping).getReferenceDescriptor() : (mapping.isForeignReferenceMapping() ? ((descriptor = mapping.getReferenceDescriptor()) == null ? null : descriptor.getJavaClass()) : (mapping.isAggregateMapping() ? ((AggregateMapping)mapping).getReferenceDescriptor() : mapping.getAttributeAccessor().getAttributeClass()));
        }
        return type2;
    }
}

