/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.SQLResult;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class ColumnResult
extends SQLResult {
    protected DatabaseField column;

    public ColumnResult(DatabaseField column) {
        if (column == null || column.getName() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_value_for_column_result"));
        }
        this.column = column;
    }

    public ColumnResult(String column) {
        if (column == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_value_for_column_result"));
        }
        this.column = new DatabaseField(column);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        this.column.convertClassNamesToClasses(classLoader);
    }

    public DatabaseField getColumn() {
        return this.column;
    }

    @Override
    public Object getValueFromRecord(DatabaseRecord record, ResultSetMappingQuery query) {
        return record.get(this.column);
    }

    @Override
    public boolean isColumnResult() {
        return true;
    }
}

