/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.adapter;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.MediaType;
import org.glassfish.admin.rest.adapter.LocatorBridge;
import org.glassfish.admin.rest.adapter.Reloader;
import org.glassfish.admin.rest.adapter.RestResourceProvider;
import org.glassfish.admin.rest.resources.ReloadResource;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.common.util.admin.RestSessionManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.CsrfProtectionFilter;

public abstract class AbstractRestResourceProvider
implements RestResourceProvider,
Serializable {
    protected Map<String, MediaType> mappings;

    protected AbstractRestResourceProvider() {
    }

    @Override
    public boolean enableModifAccessToInstances() {
        return false;
    }

    protected Map<String, MediaType> getMimeMappings() {
        if (this.mappings == null) {
            this.mappings = new HashMap<String, MediaType>();
            this.mappings.put("xml", MediaType.APPLICATION_XML_TYPE);
            this.mappings.put("json", MediaType.APPLICATION_JSON_TYPE);
            this.mappings.put("html", MediaType.TEXT_HTML_TYPE);
            this.mappings.put("js", new MediaType("text", "javascript"));
        }
        return this.mappings;
    }

    protected Feature getJsonFeature() {
        return new JettisonFeature();
    }

    @Override
    public ResourceConfig getResourceConfig(Set<Class<?>> classes, final ServerContext sc, final ServiceLocator habitat, Set<? extends Binder> additionalBinders) throws EndpointRegistrationException {
        final Reloader r = new Reloader();
        ResourceConfig rc = new ResourceConfig(classes);
        rc.property("jersey.config.server.mediaTypeMappings", this.getMimeMappings());
        rc.register((Class)CsrfProtectionFilter.class);
        rc.register(r);
        rc.register((Class)ReloadResource.class);
        rc.register(new MultiPartFeature());
        rc.register(new AbstractBinder(){

            @Override
            protected void configure() {
                AbstractActiveDescriptor<Reloader> descriptor = BuilderHelper.createConstantDescriptor(r);
                descriptor.addContractType((Type)((Object)Reloader.class));
                this.bind(descriptor);
                AbstractActiveDescriptor<ServerContext> scDescriptor = BuilderHelper.createConstantDescriptor(sc);
                scDescriptor.addContractType((Type)((Object)ServerContext.class));
                this.bind(scDescriptor);
                LocatorBridge locatorBridge = new LocatorBridge(habitat);
                AbstractActiveDescriptor<LocatorBridge> hDescriptor = BuilderHelper.createConstantDescriptor(locatorBridge);
                this.bind(hDescriptor);
                RestSessionManager rsm = habitat.getService(RestSessionManager.class, new Annotation[0]);
                AbstractActiveDescriptor<RestSessionManager> rmDescriptor = BuilderHelper.createConstantDescriptor(rsm);
                this.bind(rmDescriptor);
            }
        });
        for (Binder binder : additionalBinders) {
            rc.register(binder);
        }
        rc.property("jersey.config.workers.legacyOrdering", true);
        return rc;
    }
}

