/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.composite;

enum Primitive {
    DOUBLE("D", 175, 24),
    FLOAT("F", 174, 23),
    LONG("J", 173, 22),
    SHORT("S", 172, 21),
    INT("I", 172, 21),
    BYTE("B", 172, 21),
    BOOLEAN("Z", 172, 21);

    private final int returnOpcode;
    private final int setOpcode;
    private final String internalType;

    private Primitive(String type2, int returnOpcode, int setOpcode) {
        this.internalType = type2;
        this.returnOpcode = returnOpcode;
        this.setOpcode = setOpcode;
    }

    public int getReturnOpcode() {
        return this.returnOpcode;
    }

    public int getSetOpCode() {
        return this.setOpcode;
    }

    public String getInternalType() {
        return this.internalType;
    }

    static Primitive getPrimitive(String type2) {
        if ("S".equals(type2) || "short".equals(type2)) {
            return SHORT;
        }
        if ("J".equals(type2) || "long".equals(type2)) {
            return LONG;
        }
        if ("I".equals(type2) || "int".equals(type2)) {
            return INT;
        }
        if ("F".equals(type2) || "float".equals(type2)) {
            return FLOAT;
        }
        if ("D".equals(type2) || "double".equals(type2)) {
            return DOUBLE;
        }
        if ("B".equals(type2) || "byte".equals(type2)) {
            return BYTE;
        }
        if ("Z".equals(type2) || "boolean".equals(type2)) {
            return BOOLEAN;
        }
        throw new RuntimeException("Unknown primitive type: " + type2);
    }
}

