/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.Delete;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigInjector;

public class CommandResourceMetaData {
    public String command;
    public String httpMethod;
    public String resourcePath;
    public String displayName;
    public ParameterMetaData[] commandParams;
    public String customClassName;
    private static final Map<String, List<CommandResourceMetaData>> restRedirects = new HashMap<String, List<CommandResourceMetaData>>();
    private static String[][] configBeansToCommandResourcesMap = new String[][]{{"Domain", "change-admin-password", "POST", "change-admin-password", "change-admin-password"}, {"Domain", "stop-domain", "POST", "stop", "Stop"}, {"IiopListener", "create-ssl", "POST", "create-ssl", "Create", "id=$parent", "type=iiop-listener"}, {"IiopService", "create-ssl", "POST", "create-ssl", "Create", "type=iiop-service"}, {"LbConfig", "create-http-listener", "POST", "create-http-listener", "create-http-listener"}, {"LbConfig", "delete-http-listener", "POST", "delete-http-listener", "delete-http-listener"}, {"ListApplication", "create-lifecycle-module", "POST", "create-lifecycle-module", "Create Lifecycle Module"}, {"ListApplication", "delete-lifecycle-module", "DELETE", "delete-lifecycle-module", "Delete Lifecycle Module"}};
    private static final String[][] configBeanCustomResources = new String[][]{{"Cluster", "SystemPropertiesCliResource", "system-properties"}, {"Config", "SystemPropertiesCliResource", "system-properties"}, {"Domain", "JmxServiceUrlsResource", "jmx-urls"}, {"Domain", "LogViewerResource", "view-log"}, {"Domain", "NotificationLogViewer", "notification-log-view"}, {"Domain", "SetDomainConfigResource", "set"}, {"Domain", "SystemPropertiesCliResource", "system-properties"}, {"NetworkListener", "FindHttpProtocolResource", "find-http-protocol"}, {"Server", "SystemPropertiesCliResource", "system-properties"}};

    public static List<CommandResourceMetaData> getMetaData(String beanName) {
        LinkedList<CommandResourceMetaData> retVal = new LinkedList<CommandResourceMetaData>();
        for (String[] currentRow : configBeansToCommandResourcesMap) {
            if (!beanName.equals(currentRow[0])) continue;
            CommandResourceMetaData metaData = new CommandResourceMetaData();
            metaData.command = currentRow[1];
            metaData.httpMethod = currentRow[2];
            metaData.resourcePath = currentRow[3];
            metaData.displayName = currentRow[4];
            int PARAMETER_START_INDEX = 5;
            if (currentRow.length > PARAMETER_START_INDEX) {
                metaData.commandParams = new ParameterMetaData[currentRow.length - PARAMETER_START_INDEX];
                for (int i = PARAMETER_START_INDEX; i < currentRow.length; ++i) {
                    ParameterMetaData currentParam;
                    String[] nameValue = currentRow[i].split("=", 2);
                    metaData.commandParams[i - PARAMETER_START_INDEX] = currentParam = new ParameterMetaData();
                    currentParam.name = nameValue[0];
                    currentParam.value = nameValue[1];
                }
            }
            retVal.add(metaData);
        }
        List<CommandResourceMetaData> restRedirectPointToBean = CommandResourceMetaData.getRestRedirectPointToBean(beanName);
        if (restRedirectPointToBean != null) {
            retVal.addAll(restRedirectPointToBean);
        }
        return retVal;
    }

    public static List<CommandResourceMetaData> getCustomResourceMapping(String beanName) {
        LinkedList<CommandResourceMetaData> customResources = new LinkedList<CommandResourceMetaData>();
        for (String[] row : configBeanCustomResources) {
            if (!row[0].equals(beanName)) continue;
            CommandResourceMetaData metaData = new CommandResourceMetaData();
            metaData.customClassName = row[1];
            metaData.resourcePath = row[2];
            customResources.add(metaData);
        }
        return customResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CommandResourceMetaData> getRestRedirectPointToBean(String beanName) {
        Map<String, List<CommandResourceMetaData>> map = restRedirects;
        synchronized (map) {
            if (restRedirects.isEmpty()) {
                ServiceLocator habitat = Globals.getDefaultHabitat();
                CommandResourceMetaData.processConfigBeans(habitat);
                List<ActiveDescriptor<?>> iter = habitat.getDescriptors(BuilderHelper.createContractFilter(AdminCommand.class.getName()));
                for (ActiveDescriptor<?> ad : iter) {
                    RestEndpoint[] list;
                    Class<?> clazz;
                    RestEndpoints endpoints;
                    if (!ad.getQualifiers().contains(RestEndpoints.class.getName())) continue;
                    if (!ad.isReified()) {
                        try {
                            habitat.reifyDescriptor(ad);
                        }
                        catch (MultiException me) {
                            continue;
                        }
                    }
                    if ((endpoints = (clazz = ad.getImplementationClass()).getAnnotation(RestEndpoints.class)) == null || (list = endpoints.value()) == null || list.length <= 0) continue;
                    for (RestEndpoint endpoint : list) {
                        Service service = clazz.getAnnotation(Service.class);
                        String configBean = endpoint.configBean().getSimpleName();
                        CommandResourceMetaData metaData = new CommandResourceMetaData();
                        metaData.command = service.name();
                        metaData.httpMethod = endpoint.opType().name();
                        metaData.resourcePath = endpoint.path().isEmpty() ? service.name() : endpoint.path();
                        metaData.displayName = endpoint.description().isEmpty() ? metaData.resourcePath : endpoint.description();
                        metaData.commandParams = new ParameterMetaData[endpoint.params().length];
                        int index = 0;
                        for (RestParam param : endpoint.params()) {
                            ParameterMetaData currentParam;
                            metaData.commandParams[index] = currentParam = new ParameterMetaData();
                            currentParam.name = param.name();
                            currentParam.value = param.value();
                            ++index;
                        }
                        CommandResourceMetaData.addCommandMetaData(configBean, metaData);
                    }
                }
            }
        }
        return restRedirects.get(beanName);
    }

    private static void processConfigBeans(ServiceLocator serviceLocator) {
        List<ActiveDescriptor<?>> allDescriptors = serviceLocator.getDescriptors(BuilderHelper.createContractFilter(ConfigInjector.class.getName()));
        HashSet<String> alreadyChecked = new HashSet<String>();
        for (ActiveDescriptor<?> ad : allDescriptors) {
            List<String> targets = ad.getMetadata().get("target");
            if (targets == null) continue;
            for (String t : targets) {
                if (alreadyChecked.contains(t)) continue;
                alreadyChecked.add(t);
                try {
                    Class<?> tclass = Class.forName(t);
                    if (tclass == null || !ConfigBeanProxy.class.isAssignableFrom(tclass)) continue;
                    String beanName = tclass.getSimpleName();
                    for (Method m : tclass.getMethods()) {
                        if (m.isAnnotationPresent(Create.class)) {
                            CommandResourceMetaData.addCreateMethod(beanName, m, m.getAnnotation(Create.class));
                            continue;
                        }
                        if (!m.isAnnotationPresent(Delete.class)) continue;
                        CommandResourceMetaData.addDeleteMethod(beanName, m, m.getAnnotation(Delete.class));
                    }
                }
                catch (ClassNotFoundException cnfe) {
                }
            }
        }
    }

    private static void addCreateMethod(String beanName, Method m, Create create) {
        CommandResourceMetaData metaData = new CommandResourceMetaData();
        metaData.command = create.value();
        metaData.httpMethod = "POST";
        metaData.resourcePath = create.value();
        metaData.displayName = create.value();
        CommandResourceMetaData.addCommandMetaData(beanName, metaData);
    }

    private static void addDeleteMethod(String beanName, Method m, Delete delete) {
        CommandResourceMetaData metaData = new CommandResourceMetaData();
        metaData.command = delete.value();
        metaData.httpMethod = "DELETE";
        metaData.resourcePath = delete.value();
        metaData.displayName = delete.value();
        CommandResourceMetaData.addCommandMetaData(beanName, metaData);
    }

    private static void addCommandMetaData(String beanName, CommandResourceMetaData cmd) {
        List<CommandResourceMetaData> commandList = restRedirects.get(beanName);
        if (commandList == null) {
            commandList = new ArrayList<CommandResourceMetaData>();
            restRedirects.put(beanName, commandList);
        }
        commandList.add(cmd);
    }

    public static class ParameterMetaData {
        String name;
        String value;
    }
}

