/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.enterprise.server.logging.logviewer.backend.LogFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.adapter.LocatorBridge;
import org.glassfish.admin.rest.logviewer.CharSpool;
import org.glassfish.admin.rest.logviewer.LineEndNormalizingWriter;
import org.glassfish.admin.rest.logviewer.WriterOutputStream;
import org.glassfish.admin.rest.resources.custom.StructuredLogViewerResource;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.Dom;

public class NotificationLogViewer {
    private static final Logger logger = Logger.getLogger("NotificationLogViewer");
    List<String> fileBody = new ArrayList<String>();
    @Context
    protected ServiceLocator injector;
    @Context
    protected UriInfo ui;
    @Context
    protected LocatorBridge habitat;
    private Source source;
    protected Charset charset;
    private volatile boolean completed;

    public void setEntity(Dom p) {
    }

    @Path(value="details/")
    public StructuredLogViewerResource getDomainUptimeResource() {
        StructuredLogViewerResource resource = this.injector.createAndInitialize(StructuredLogViewerResource.class);
        return resource;
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    public Response get(@QueryParam(value="start") @DefaultValue(value="0") long start, @QueryParam(value="instanceName") @DefaultValue(value="server") String instanceName, @Context HttpHeaders hh) throws IOException {
        CharSpool spool;
        long size;
        boolean gzipOK = true;
        MultivaluedMap<String, String> headerParams = hh.getRequestHeaders();
        String acceptEncoding = headerParams.getFirst("Accept-Encoding");
        if (acceptEncoding == null || acceptEncoding.indexOf("gzip") == -1) {
            gzipOK = false;
        }
        LogFilter logFilter = this.habitat.getRemoteLocator().getService(LogFilter.class, new Annotation[0]);
        String logLocation = "";
        logLocation = logFilter.getLogFileForGivenTarget(instanceName);
        this.readServerLogFile(logLocation);
        String logFolderLocation = logLocation.replace("server.log", "");
        String notificationFolderLocation = logFolderLocation + File.separator + "notificationLogs";
        this.createNotificationLogFolder(notificationFolderLocation);
        String notificationLogLocation = notificationFolderLocation + File.separator + "notification.log";
        this.writeToNotificationLogFile(notificationLogLocation);
        this.initLargeText(new File(notificationLogLocation), false);
        if (!this.source.exists()) {
            UriBuilder uriBuilder = this.ui.getAbsolutePathBuilder();
            uriBuilder.queryParam("start", 0);
            uriBuilder.queryParam("instanceName", instanceName);
            return Response.ok(new StreamingOutput(){

                @Override
                public void write(OutputStream out) throws IOException, WebApplicationException {
                }
            }).header("X-Text-Append-Next", uriBuilder.build(new Object[0])).build();
        }
        if (this.source.length() < start) {
            start = 0L;
        }
        if ((size = this.writeLogTo(start, spool = new CharSpool())) < 10000L) {
            gzipOK = false;
        }
        final boolean gz = gzipOK;
        Response.ResponseBuilder rp = Response.ok(new StreamingOutput(){

            @Override
            public void write(OutputStream out) throws IOException, WebApplicationException {
                Writer w = NotificationLogViewer.this.getWriter(out, gz);
                spool.writeTo(new LineEndNormalizingWriter(w));
                w.flush();
                w.close();
            }
        });
        UriBuilder uriBuilder = this.ui.getAbsolutePathBuilder();
        uriBuilder.queryParam("start", size);
        uriBuilder.queryParam("instanceName", instanceName);
        URI next = uriBuilder.build(new Object[0]);
        rp.header("X-Text-Append-Next", next);
        if (gzipOK) {
            rp = rp.header("Content-Encoding", "gzip");
        }
        return rp.build();
    }

    private Writer getWriter(OutputStream out, boolean gzipOK) throws IOException {
        if (!gzipOK) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter((OutputStream)new GZIPOutputStream(out), "UTF-8");
    }

    public void initLargeText(File file, boolean completed) {
        this.initLargeText(file, Charset.defaultCharset(), completed);
    }

    public void initLargeText(final File file, Charset charset, boolean completed) {
        this.charset = charset;
        this.source = new Source(){

            @Override
            public Session open() throws IOException {
                return new FileSession(file);
            }

            @Override
            public long length() {
                return file.length();
            }

            @Override
            public boolean exists() {
                return file.exists();
            }
        };
        this.completed = completed;
    }

    public void markAsComplete() {
        this.completed = true;
    }

    public boolean isComplete() {
        return this.completed;
    }

    private long writeLogTo(long start, Writer w) throws IOException {
        return this.writeLogTo(start, new WriterOutputStream(w, this.charset));
    }

    private long writeLogTo(long start, OutputStream os) throws IOException {
        long count = 0L;
        Session f = this.source.open();
        f.skip(start);
        if (this.completed) {
            int sz;
            byte[] buf = new byte[1024];
            while ((sz = f.read(buf)) >= 0) {
                os.write(buf, 0, sz);
            }
            count += (long)sz;
        } else {
            ByteBuf buf = new ByteBuf(null, f);
            HeadMark head = new HeadMark(buf);
            TailMark tail = new TailMark(buf);
            while (tail.moveToNextLine(f)) {
                count += head.moveTo(tail, os);
            }
            count += head.finish(os);
        }
        f.close();
        os.flush();
        return count + start;
    }

    public void createNotificationLogFolder(String FolderName) {
        File notificationFolder = new File(FolderName);
        if (!notificationFolder.exists()) {
            if (notificationFolder.mkdir()) {
                logger.log(Level.INFO, "Notification Folder was created on " + FolderName);
            } else {
                logger.log(Level.SEVERE, "Failed to create Notification Folder");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToNotificationLogFile(String fileName) {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new FileOutputStream(fileName));
            for (String text : this.fileBody) {
                if (text.contains("WARNING") || text.contains("SEVERE") || text.contains("FINE") || text.contains("CONFIG") || text.contains("INFO")) {
                    pw.println("\n" + text);
                    continue;
                }
                pw.println(text);
            }
            pw.close();
        }
    }

    public void readServerLogFile(String file) {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                if (!sCurrentLine.contains("LogNotifierService") && !sCurrentLine.contains("RequestEvent") && !sCurrentLine.contains("ServletRequestEvent") && !sCurrentLine.contains("conversationId") && !sCurrentLine.contains("elapsedTime") && !sCurrentLine.contains("user-agent") && !sCurrentLine.contains("requestTracing") && !sCurrentLine.contains("alarmType")) continue;
                this.fileBody.add(sCurrentLine);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private static final class FileSession
    implements Session {
        private final RandomAccessFile file;

        public FileSession(File file) throws IOException {
            this.file = new RandomAccessFile(file, "r");
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }

        @Override
        public void skip(long start) throws IOException {
            this.file.seek(this.file.getFilePointer() + start);
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.file.read(buf);
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            return this.file.read(buf, offset, length);
        }
    }

    private static interface Session {
        public void close() throws IOException;

        public void skip(long var1) throws IOException;

        public int read(byte[] var1) throws IOException;

        public int read(byte[] var1, int var2, int var3) throws IOException;
    }

    private static final class ByteBuf {
        private final byte[] buf = new byte[1024];
        private int size = 0;
        private ByteBuf next;

        public ByteBuf(ByteBuf previous, Session f) throws IOException {
            if (previous != null) {
                assert (previous.next == null);
                previous.next = this;
            }
            while (!this.isFull()) {
                int chunk = f.read(this.buf, this.size, this.buf.length - this.size);
                if (chunk == -1) {
                    return;
                }
                this.size += chunk;
            }
        }

        public boolean isFull() {
            return this.buf.length == this.size;
        }
    }

    private static final class TailMark
    extends Mark {
        public TailMark(ByteBuf buf) {
            super(buf);
        }

        boolean moveToNextLine(Session f) throws IOException {
            while (true) {
                if (this.pos == this.buf.size) {
                    if (!this.buf.isFull()) {
                        return false;
                    }
                    this.buf = new ByteBuf(this.buf, f);
                    this.pos = 0;
                    continue;
                }
                byte b = this.buf.buf[this.pos++];
                if (b == 13 || b == 10) break;
            }
            return true;
        }
    }

    private static final class HeadMark
    extends Mark {
        public HeadMark(ByteBuf buf) {
            super(buf);
        }

        long moveTo(Mark that, OutputStream os) throws IOException {
            long count = 0L;
            while (this.buf != that.buf) {
                os.write(this.buf.buf, 0, this.buf.size);
                count += (long)this.buf.size;
                this.buf = this.buf.next;
                this.pos = 0;
            }
            this.pos = that.pos;
            return count;
        }

        long finish(OutputStream os) throws IOException {
            os.write(this.buf.buf, 0, this.pos);
            return this.pos;
        }
    }

    private static class Mark {
        protected ByteBuf buf;
        protected int pos;

        public Mark(ByteBuf buf) {
            this.buf = buf;
        }
    }

    private static interface Source {
        public Session open() throws IOException;

        public long length();

        public boolean exists();
    }
}

