/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IntrospectionUtils {
    private static final Logger logger = ConfigApiLoggerInfo.getLogger();
    private static final int debugLevel = 0;

    public static Method[] findMethods(Class<?> c) {
        return c.getMethods();
    }

    public static boolean setProperty(Object o, String name, String value) {
        String setter = "set" + IntrospectionUtils.capitalize(name);
        try {
            Method[] methods = IntrospectionUtils.findMethods(o.getClass());
            Method setPropertyMethodVoid = null;
            Method setPropertyMethodBool = null;
            for (Method method : methods) {
                Class<?>[] paramTypes = method.getParameterTypes();
                if (!setter.equals(method.getName()) || paramTypes.length != 1 || !"java.lang.String".equals(paramTypes[0].getName())) continue;
                method.invoke(o, value);
                return true;
            }
            for (Method method : methods) {
                boolean ok = true;
                if (setter.equals(method.getName()) && method.getParameterTypes().length == 1) {
                    Class<?> paramType = method.getParameterTypes()[0];
                    Object[] params = new Object[1];
                    if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
                        try {
                            params[0] = new Integer(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Long".equals(paramType.getName()) || "long".equals(paramType.getName())) {
                        try {
                            params[0] = new Long(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
                        params[0] = Boolean.valueOf(value);
                    } else if ("java.net.InetAddress".equals(paramType.getName())) {
                        try {
                            params[0] = InetAddress.getByName(value);
                        }
                        catch (UnknownHostException exc) {
                            IntrospectionUtils.debug("Unable to resolve host name:" + value);
                            ok = false;
                        }
                    } else {
                        IntrospectionUtils.debug("Unknown type " + paramType.getName());
                    }
                    if (ok) {
                        method.invoke(o, params);
                        return true;
                    }
                }
                if (!"setProperty".equals(method.getName())) continue;
                if (method.getReturnType().equals(Boolean.TYPE)) {
                    setPropertyMethodBool = method;
                    continue;
                }
                setPropertyMethodVoid = method;
            }
            if (setPropertyMethodBool != null || setPropertyMethodVoid != null) {
                Object[] params = new Object[]{name, value};
                if (setPropertyMethodBool != null) {
                    try {
                        return (Boolean)setPropertyMethodBool.invoke(o, params);
                    }
                    catch (IllegalArgumentException biae) {
                        if (setPropertyMethodVoid != null) {
                            setPropertyMethodVoid.invoke(o, params);
                            return true;
                        }
                        throw biae;
                    }
                }
                setPropertyMethodVoid.invoke(o, params);
                return true;
            }
        }
        catch (IllegalArgumentException ex2) {
            logger.log(Level.INFO, "IAE " + o + " " + name + " " + value, ex2);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    private static void debug(String s) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("IntrospectionUtils: " + s);
        }
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }
}

