/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.glassfish.ejb.deployment.descriptor.ScheduledTimerDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScheduledTimerNode
extends DeploymentDescriptorNode<ScheduledTimerDescriptor> {
    private ScheduledTimerDescriptor descriptor;

    public ScheduledTimerNode() {
        this.registerElementHandler(new XMLElement("timeout-method"), MethodNode.class, "setTimeoutMethod");
    }

    @Override
    public ScheduledTimerDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new ScheduledTimerDescriptor();
        }
        return this.descriptor;
    }

    @Override
    protected Map getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("second", "setSecond");
        table.put("minute", "setMinute");
        table.put("hour", "setHour");
        table.put("day-of-month", "setDayOfMonth");
        table.put("month", "setMonth");
        table.put("day-of-week", "setDayOfWeek");
        table.put("year", "setYear");
        table.put("persistent", "setPersistent");
        table.put("info", "setInfo");
        table.put("timezone", "setTimezone");
        return table;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("start".equals(element.getQName())) {
            try {
                DatatypeFactory dFactory = DatatypeFactory.newInstance();
                XMLGregorianCalendar xmlGreg = dFactory.newXMLGregorianCalendar(value);
                GregorianCalendar cal = xmlGreg.toGregorianCalendar();
                this.descriptor.setStart(cal.getTime());
            }
            catch (Exception e) {
                DOLUtils.getDefaultLogger().warning(e.getMessage());
            }
        } else if ("end".equals(element.getQName())) {
            try {
                DatatypeFactory dFactory = DatatypeFactory.newInstance();
                XMLGregorianCalendar xmlGreg = dFactory.newXMLGregorianCalendar(value);
                GregorianCalendar cal = xmlGreg.toGregorianCalendar();
                this.descriptor.setEnd(cal.getTime());
            }
            catch (Exception e) {
                DOLUtils.getDefaultLogger().warning(e.getMessage());
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, ScheduledTimerDescriptor desc) {
        String info;
        Node timerNode = super.writeDescriptor(parent, nodeName, this.descriptor);
        Element scheduleNode = ScheduledTimerNode.appendChild(timerNode, "schedule");
        ScheduledTimerNode.appendTextChild((Node)scheduleNode, "second", desc.getSecond());
        ScheduledTimerNode.appendTextChild((Node)scheduleNode, "minute", desc.getMinute());
        ScheduledTimerNode.appendTextChild((Node)scheduleNode, "hour", desc.getHour());
        ScheduledTimerNode.appendTextChild((Node)scheduleNode, "day-of-month", desc.getDayOfMonth());
        ScheduledTimerNode.appendTextChild((Node)scheduleNode, "month", desc.getMonth());
        ScheduledTimerNode.appendTextChild((Node)scheduleNode, "day-of-week", desc.getDayOfWeek());
        ScheduledTimerNode.appendTextChild((Node)scheduleNode, "year", desc.getYear());
        try {
            XMLGregorianCalendar xmlGreg;
            DatatypeFactory dFactory = DatatypeFactory.newInstance();
            GregorianCalendar cal = new GregorianCalendar();
            if (desc.getStart() != null) {
                cal.setTime(desc.getStart());
                xmlGreg = dFactory.newXMLGregorianCalendar(cal);
                ScheduledTimerNode.appendTextChild(timerNode, "start", xmlGreg.toXMLFormat());
            }
            if (desc.getEnd() != null) {
                cal.setTime(desc.getEnd());
                xmlGreg = dFactory.newXMLGregorianCalendar(cal);
                ScheduledTimerNode.appendTextChild(timerNode, "end", xmlGreg.toXMLFormat());
            }
        }
        catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, e.getMessage(), e);
        }
        MethodNode methodNode = new MethodNode();
        methodNode.writeJavaMethodDescriptor(timerNode, "timeout-method", desc.getTimeoutMethod());
        ScheduledTimerNode.appendTextChild(timerNode, "persistent", Boolean.toString(desc.getPersistent()));
        String tz = desc.getTimezone();
        if (tz != null) {
            ScheduledTimerNode.appendTextChild(timerNode, "timezone", tz);
        }
        if ((info = desc.getInfo()) != null) {
            ScheduledTimerNode.appendTextChild(timerNode, "info", info);
        }
        return timerNode;
    }
}

