/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.frames.HeaderBlockHead;
import org.glassfish.grizzly.http2.hpack.Decoder;
import org.glassfish.grizzly.http2.hpack.DecodingCallback;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

public class HeadersDecoder {
    private final Decoder hpackDecoder;
    private final MemoryManager memoryManager;
    private HeaderBlockHead firstHeaderFrame;
    private Buffer inBuffer;

    public HeadersDecoder(MemoryManager memoryManager, int maxHeaderSize, int maxHeaderTableSize) {
        this.memoryManager = memoryManager;
        this.hpackDecoder = new Decoder(maxHeaderTableSize);
    }

    public void append(Buffer buffer) {
        this.inBuffer = Buffers.appendBuffers(this.memoryManager, this.inBuffer, buffer, true);
    }

    public void decode(DecodingCallback callback) throws IOException {
        if (this.inBuffer != null) {
            this.hpackDecoder.decode(this.inBuffer, !this.isProcessingHeaders(), callback);
            this.inBuffer.tryDispose();
            this.inBuffer = null;
        }
    }

    public HeaderBlockHead finishHeader() {
        HeaderBlockHead firstHeaderFrameLocal = this.firstHeaderFrame;
        this.firstHeaderFrame = null;
        return firstHeaderFrameLocal;
    }

    public void setFirstHeaderFrame(HeaderBlockHead firstHeaderFrame) {
        this.firstHeaderFrame = firstHeaderFrame;
    }

    public boolean isProcessingHeaders() {
        return this.firstHeaderFrame != null;
    }
}

