/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jta.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="unfreeze-transaction-service")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@ExecuteOn(value={RuntimeType.INSTANCE})
@PerLookup
@I18n(value="unfreeze.transaction.service")
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="unfreeze-transaction-service", description="Unfreeze Transaction Service", params={@RestParam(name="id", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="unfreeze-transaction-service", description="Unfreeze Transaction Service", params={@RestParam(name="id", value="$parent")}), @RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="unfreeze-transaction-service", description="Unfreeze Transaction Service")})
public class UnFreezeTransactionService
implements AdminCommand {
    private static StringManager localStrings = StringManager.getManager(UnFreezeTransactionService.class);
    private static final Logger logger = LogDomains.getLogger(UnFreezeTransactionService.class, "javax.enterprise.resource.jta");
    @Param(optional=true)
    String target = "server";
    @Inject
    JavaEETransactionManager transactionMgr;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            if (!this.transactionMgr.isFrozen()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("There is no frozen transaction.");
                }
                return;
            }
            this.transactionMgr.unfreeze();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getString("unfreeze.transaction.service.failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }
}

