/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.io.PrintStream;
import java.util.Map;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.dynamic.codegen.impl.ASMUtil;
import org.glassfish.pfl.dynamic.codegen.impl.AssignmentStatement;
import org.glassfish.pfl.dynamic.codegen.impl.BlockStatement;
import org.glassfish.pfl.dynamic.codegen.impl.BreakStatement;
import org.glassfish.pfl.dynamic.codegen.impl.ByteCodeUtility;
import org.glassfish.pfl.dynamic.codegen.impl.CaseBranch;
import org.glassfish.pfl.dynamic.codegen.impl.ClassGeneratorImpl;
import org.glassfish.pfl.dynamic.codegen.impl.DefinitionStatement;
import org.glassfish.pfl.dynamic.codegen.impl.EmitterFactory;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionFactory;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionInternal;
import org.glassfish.pfl.dynamic.codegen.impl.FieldGenerator;
import org.glassfish.pfl.dynamic.codegen.impl.IfStatement;
import org.glassfish.pfl.dynamic.codegen.impl.MethodGenerator;
import org.glassfish.pfl.dynamic.codegen.impl.MyLabel;
import org.glassfish.pfl.dynamic.codegen.impl.Node;
import org.glassfish.pfl.dynamic.codegen.impl.ReturnStatement;
import org.glassfish.pfl.dynamic.codegen.impl.Statement;
import org.glassfish.pfl.dynamic.codegen.impl.SwitchStatement;
import org.glassfish.pfl.dynamic.codegen.impl.ThrowStatement;
import org.glassfish.pfl.dynamic.codegen.impl.TreeWalker;
import org.glassfish.pfl.dynamic.codegen.impl.TreeWalkerContext;
import org.glassfish.pfl.dynamic.codegen.impl.TryStatement;
import org.glassfish.pfl.dynamic.codegen.impl.VariableInternal;
import org.glassfish.pfl.dynamic.codegen.impl.WhileStatement;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Variable;
import org.glassfish.pfl.objectweb.asm.ClassWriter;

public class ASMByteCodeVisitor
extends TreeWalker {
    private ClassWriter cw;
    private ByteCodeUtility bcu;
    private boolean debug;
    private PrintStream ps;

    public ASMByteCodeVisitor(TreeWalkerContext context, ClassWriter cw) {
        this(context, cw, false, System.out);
    }

    public ASMByteCodeVisitor(TreeWalkerContext context, ClassWriter cw, boolean debug, PrintStream ps) {
        super(context);
        context.push(this);
        this.cw = cw;
        this.debug = debug;
        this.ps = ps;
    }

    private <T> T findNode(Class<T> cls, Node arg) {
        Node current;
        for (current = arg; current != null && !cls.isInstance(current); current = current.parent()) {
        }
        assert (current != null);
        return cls.cast(current);
    }

    private MethodGenerator findMethodGenerator(Node arg) {
        MethodGenerator mg = this.findNode(MethodGenerator.class, arg);
        assert (mg != null);
        return mg;
    }

    private ClassGeneratorImpl findClassGenerator(Node arg) {
        ClassGeneratorImpl cg = this.findNode(ClassGeneratorImpl.class, arg);
        assert (cg != null);
        return cg;
    }

    static MyLabel nextLabel(Node node) {
        Object result = null;
        Node pos = node;
        do {
            assert (pos != null);
            Node next = ASMUtil.next.get(pos);
            if (next != null) {
                return ASMUtil.statementStartLabel.get(next);
            }
            pos = pos.parent();
        } while (!(pos instanceof MethodGenerator));
        return ASMUtil.returnLabel.get(pos);
    }

    @Override
    public boolean preNode(Node arg) {
        return true;
    }

    @Override
    public void postNode(Node arg) {
    }

    @Override
    public boolean preClassGenerator(ClassGeneratorImpl arg) {
        this.bcu = new ByteCodeUtility(this.cw, arg, this.debug, this.ps);
        return true;
    }

    @Override
    public boolean classGeneratorBeforeFields(ClassGeneratorImpl arg) {
        return true;
    }

    @Override
    public void classGeneratorBeforeInitializer(ClassGeneratorImpl arg) {
    }

    @Override
    public void classGeneratorBeforeMethod(ClassGeneratorImpl arg) {
    }

    @Override
    public void classGeneratorBeforeConstructor(ClassGeneratorImpl arg) {
    }

    @Override
    public void postClassGenerator(ClassGeneratorImpl arg) {
        this.postNode(arg);
    }

    @Override
    public boolean preFieldGenerator(FieldGenerator arg) {
        this.bcu.addField(arg);
        return true;
    }

    @Override
    public boolean preMethodGenerator(MethodGenerator arg) {
        this.bcu.emitMethodStart(arg);
        for (Variable var : arg.arguments()) {
            this.recordVariable(var);
        }
        return true;
    }

    @Override
    public boolean methodGeneratorBeforeArguments(MethodGenerator arg) {
        return false;
    }

    @Override
    public void postMethodGenerator(MethodGenerator arg) {
        this.bcu.emitMethodEnd(arg, ASMUtil.returnLabel.get(arg), ASMUtil.returnVariable.get(arg), this.debug);
    }

    @Override
    public boolean preStatement(Statement arg) {
        this.bcu.emitLabel(ASMUtil.statementStartLabel, arg);
        return true;
    }

    @Override
    public void postStatement(Statement arg) {
        this.bcu.emitLabel(ASMUtil.statementEndLabel, arg);
        this.postNode(arg);
    }

    @Override
    public boolean preThrowStatement(ThrowStatement arg) {
        return this.preStatement(arg);
    }

    @Override
    public void postThrowStatement(ThrowStatement arg) {
        this.bcu.emitThrow();
        this.postStatement(arg);
    }

    @Override
    public boolean preAssignmentStatement(AssignmentStatement arg) {
        ExpressionFactory.ExpressionBase expr;
        ExpressionInternal lhs = arg.left();
        ExpressionInternal rhs = arg.right();
        assert (lhs.isAssignable());
        if (lhs instanceof Variable) {
            rhs.accept(this.context.current());
        } else if (lhs instanceof ExpressionFactory.NonStaticFieldAccessExpression) {
            expr = (ExpressionFactory.NonStaticFieldAccessExpression)ExpressionFactory.NonStaticFieldAccessExpression.class.cast(lhs);
            ((ExpressionInternal)((ExpressionFactory.FieldAccessExpressionBase)expr).target()).accept(this.context.current());
            rhs.accept(this.context.current());
        } else if (lhs instanceof ExpressionFactory.StaticFieldAccessExpression) {
            rhs.accept(this.context.current());
        } else if (lhs instanceof ExpressionFactory.ArrayIndexExpression) {
            expr = (ExpressionFactory.ArrayIndexExpression)ExpressionFactory.ArrayIndexExpression.class.cast(lhs);
            ((ExpressionInternal)((ExpressionFactory.ArrayIndexExpression)expr).expr()).accept(this.context.current());
            ((ExpressionInternal)((ExpressionFactory.ArrayIndexExpression)expr).index()).accept(this.context.current());
            rhs.accept(this.context.current());
        } else {
            throw new IllegalArgumentException("ASMByteCodeVisitor.preAssignmentStatement called with illegal left expression " + lhs);
        }
        EmitterFactory.Emitter emitter = ASMUtil.emitter.get(lhs);
        this.bcu.callEmitter(emitter);
        this.preStatement(arg);
        return false;
    }

    @Override
    public void assignmentStatementBeforeLeftSide(AssignmentStatement arg) {
    }

    @Override
    public void postAssignmentStatement(AssignmentStatement arg) {
    }

    @Override
    public boolean preBlockStatement(BlockStatement arg) {
        ASMUtil.lastStatement.set(arg, null);
        return this.preStatement(arg);
    }

    @Override
    public void blockStatementBeforeBodyStatement(BlockStatement arg, Statement stmt) {
        Statement lastStatement = ASMUtil.lastStatement.get(arg);
        this.popIfNeeded(lastStatement);
        ASMUtil.lastStatement.set(arg, stmt);
    }

    @Override
    public void postBlockStatement(BlockStatement arg) {
        Statement lastStatement = ASMUtil.lastStatement.get(arg);
        this.popIfNeeded(lastStatement);
        this.postStatement(arg);
    }

    private void popIfNeeded(Statement lastStatement) {
        ExpressionInternal expr;
        if (lastStatement != null && lastStatement instanceof ExpressionInternal && !(expr = (ExpressionInternal)ExpressionInternal.class.cast(lastStatement)).type().equals(Type._void())) {
            this.bcu.emitPop();
        }
    }

    @Override
    public boolean preCaseBranch(CaseBranch arg) {
        return this.preBlockStatement(arg);
    }

    @Override
    public void caseBranchBeforeBodyStatement(CaseBranch arg) {
    }

    @Override
    public void postCaseBranch(CaseBranch arg) {
        this.postBlockStatement(arg);
    }

    @Override
    public boolean preDefinitionStatement(DefinitionStatement arg) {
        this.preStatement(arg);
        ((ExpressionInternal)arg.expr()).accept(this.context.current());
        ((VariableInternal)arg.var()).accept(this.context.current());
        this.recordVariable(arg.var());
        return false;
    }

    @Override
    public boolean definitionStatementBeforeExpr(DefinitionStatement arg) {
        return false;
    }

    @Override
    public void postDefinitionStatement(DefinitionStatement arg) {
        this.postStatement(arg);
    }

    @Override
    public boolean preIfStatement(IfStatement arg) {
        return this.preStatement(arg);
    }

    @Override
    public void ifStatementBeforeTruePart(IfStatement arg) {
        this.bcu.emitConditionalBranch(ASMUtil.statementStartLabel.get(arg.falsePart()));
    }

    @Override
    public boolean ifStatementBeforeFalsePart(IfStatement arg) {
        this.bcu.emitBranch(ASMByteCodeVisitor.nextLabel(arg));
        this.bcu.emitLabel(ASMUtil.statementStartLabel, arg.falsePart());
        return true;
    }

    @Override
    public void postIfStatement(IfStatement arg) {
        this.postStatement(arg);
    }

    private void emitJsrToFinallyBlock(TryStatement stmt) {
        BlockStatement fb = stmt.finalPart();
        if (!fb.isEmpty()) {
            this.bcu.emitJsr(ASMUtil.statementStartLabel.get(fb));
        }
    }

    private void callFinallyBlocks(Node arg) {
        for (Node current = arg; current != null; current = current.parent()) {
            if (!(current instanceof TryStatement)) continue;
            this.emitJsrToFinallyBlock((TryStatement)TryStatement.class.cast(current));
        }
    }

    @Override
    public boolean preBreakStatement(BreakStatement arg) {
        this.preStatement(arg);
        return true;
    }

    @Override
    public void postBreakStatement(BreakStatement arg) {
        boolean foundBreak = false;
        for (Node current = arg.parent(); current != null; current = current.parent()) {
            if (current instanceof TryStatement) {
                this.emitJsrToFinallyBlock((TryStatement)TryStatement.class.cast(current));
                continue;
            }
            if (current instanceof SwitchStatement) {
                this.bcu.emitBranch(ASMByteCodeVisitor.nextLabel(current));
                continue;
            }
            if (!(current instanceof WhileStatement)) continue;
            this.bcu.emitBranch(ASMByteCodeVisitor.nextLabel(current));
        }
        this.postStatement(arg);
    }

    @Override
    public boolean preReturnStatement(ReturnStatement arg) {
        this.preStatement(arg);
        return true;
    }

    @Override
    public void postReturnStatement(ReturnStatement arg) {
        MethodGenerator mg = this.findMethodGenerator(arg);
        Variable var = ASMUtil.returnVariable.get(mg);
        if (var != null) {
            this.bcu.callEmitter(ASMUtil.setEmitter.get((VariableInternal)var));
        }
        this.callFinallyBlocks(arg);
        this.bcu.emitBranch(ASMUtil.returnLabel.get(mg));
        this.postStatement(arg);
    }

    @Override
    public boolean preSwitchStatement(SwitchStatement arg) {
        this.preStatement(arg);
        this.postStatement(arg);
        return false;
    }

    @Override
    public boolean switchStatementBeforeCaseBranches(SwitchStatement arg) {
        return true;
    }

    @Override
    public boolean switchStatementBeforeDefault(SwitchStatement arg) {
        return true;
    }

    @Override
    public void postSwitchStatement(SwitchStatement arg) {
    }

    @Override
    public boolean preTryStatement(TryStatement arg) {
        ASMUtil.statementStartLabel.get(arg.bodyPart());
        ASMUtil.lastBlock.set(arg, arg.bodyPart());
        return this.preStatement(arg);
    }

    @Override
    public void tryStatementBeforeBlock(TryStatement arg, Type type2, Variable var, BlockStatement block) {
        this.finishLastBlock(arg);
        ASMUtil.lastBlock.set(arg, block);
        ASMUtil.statementStartLabel.get(block);
        this.bcu.emitLabel(ASMUtil.statementStartLabel, block);
        this.bcu.callEmitter(ASMUtil.setEmitter.get((VariableInternal)var));
        this.recordVariable(var);
    }

    private void finishLastBlock(TryStatement arg) {
        BlockStatement lastBlock = ASMUtil.lastBlock.get(arg);
        ASMUtil.throwEndLabel.get(lastBlock);
        this.bcu.emitLabel(ASMUtil.throwEndLabel, lastBlock);
        if (!arg.finalPart().isEmpty()) {
            this.bcu.emitJsr(ASMUtil.statementStartLabel.get(arg.finalPart()));
        }
        this.bcu.emitBranch(ASMByteCodeVisitor.nextLabel(arg));
    }

    @Override
    public boolean tryStatementBeforeFinalPart(TryStatement arg) {
        this.finishLastBlock(arg);
        if (!arg.finalPart().isEmpty()) {
            ASMUtil.uncaughtExceptionHandler.get(arg);
            this.bcu.emitLabel(ASMUtil.uncaughtExceptionHandler, arg);
            VariableInternal uncaughtException = (VariableInternal)ASMUtil.uncaughtException.get(arg);
            this.bcu.callEmitter(ASMUtil.setEmitter.get(uncaughtException));
            this.bcu.emitJsr(ASMUtil.statementStartLabel.get(arg.finalPart()));
            this.bcu.callEmitter(ASMUtil.getEmitter.get(uncaughtException));
            this.bcu.emitThrow();
            ASMUtil.statementStartLabel.get(arg.finalPart());
            this.bcu.emitLabel(ASMUtil.statementStartLabel, arg.finalPart());
            Variable ra = ASMUtil.returnAddress.get(arg);
            this.bcu.callEmitter(ASMUtil.setEmitter.get((VariableInternal)ra));
        }
        return true;
    }

    @Override
    public void postTryStatement(TryStatement arg) {
        if (!arg.finalPart().isEmpty()) {
            Variable ra = ASMUtil.returnAddress.get(arg);
            this.bcu.emitRet(ra);
        }
        MyLabel start = ASMUtil.statementStartLabel.get(arg.bodyPart());
        MyLabel end = ASMUtil.throwEndLabel.get(arg.bodyPart());
        for (Map.Entry<Type, Pair<Variable, BlockStatement>> entry : arg.catches().entrySet()) {
            Pair<Variable, BlockStatement> pair = entry.getValue();
            MyLabel handler = ASMUtil.statementStartLabel.get(pair.second());
            this.bcu.emitExceptionTableEntry(start, end, handler, ((VariableInternal)pair.first()).type());
        }
        if (!arg.finalPart().isEmpty()) {
            end = ASMUtil.uncaughtExceptionHandler.get(arg);
            this.bcu.emitExceptionTableEntry(start, end, end, null);
        }
        this.postStatement(arg);
    }

    @Override
    public boolean preWhileStatement(WhileStatement arg) {
        ASMUtil.statementStartLabel.get(arg);
        this.bcu.emitLabel(ASMUtil.statementStartLabel, arg);
        return this.preStatement(arg);
    }

    @Override
    public void whileStatementBeforeBody(WhileStatement arg) {
        this.bcu.emitConditionalBranch(ASMByteCodeVisitor.nextLabel(arg));
    }

    @Override
    public void postWhileStatement(WhileStatement arg) {
        this.bcu.emitBranch(ASMUtil.statementStartLabel.get(arg));
        this.postStatement(arg);
    }

    @Override
    public boolean preExpression(ExpressionInternal arg) {
        return this.preStatement(arg);
    }

    @Override
    public void postExpression(ExpressionInternal arg) {
        this.postStatement(arg);
    }

    private void recordVariable(Variable var) {
        MethodGenerator mg = ((VariableInternal)var).getAncestor(MethodGenerator.class);
        if (mg == null) {
            throw new IllegalStateException("No MethodGenerator found!");
        }
        ASMUtil.VariablesInMethod vm = ASMUtil.variablesInMethod.get(mg);
        vm.add(var);
    }

    @Override
    public boolean preVariable(Variable param) {
        VariableInternal arg = (VariableInternal)param;
        if (ASMUtil.emitter.isSet(arg)) {
            this.bcu.callEmitter(ASMUtil.emitter.get(arg));
        }
        return this.preExpression(arg);
    }

    @Override
    public void postVariable(Variable arg) {
        this.postExpression((VariableInternal)arg);
    }

    @Override
    public boolean preConstantExpression(ExpressionFactory.ConstantExpression arg) {
        this.bcu.emitConstantExpression(arg.type(), arg.value());
        return this.preExpression(arg);
    }

    @Override
    public void postConstantExpression(ExpressionFactory.ConstantExpression arg) {
        this.postExpression(arg);
    }

    @Override
    public boolean preVoidExpression(ExpressionFactory.VoidExpression arg) {
        return this.preExpression(arg);
    }

    @Override
    public void postVoidExpression(ExpressionFactory.VoidExpression arg) {
        this.postExpression(arg);
    }

    @Override
    public boolean preThisExpression(ExpressionFactory.ThisExpression arg) {
        this.bcu.emitThisExpression();
        return this.preExpression(arg);
    }

    @Override
    public void postThisExpression(ExpressionFactory.ThisExpression arg) {
        this.postExpression(arg);
    }

    @Override
    public boolean preUnaryOperatorExpression(ExpressionFactory.UnaryOperatorExpression arg) {
        return this.preExpression(arg);
    }

    @Override
    public void postUnaryOperatorExpression(ExpressionFactory.UnaryOperatorExpression arg) {
        this.postExpression(arg);
    }

    @Override
    public boolean preBinaryOperatorExpression(ExpressionFactory.BinaryOperatorExpression arg) {
        return this.preExpression(arg);
    }

    @Override
    public void binaryOperatorExpressionBeforeRight(ExpressionFactory.BinaryOperatorExpression arg) {
    }

    @Override
    public void postBinaryOperatorExpression(ExpressionFactory.BinaryOperatorExpression arg) {
        this.postExpression(arg);
        this.bcu.emitBinaryOperator(arg);
    }

    @Override
    public boolean preCastExpression(ExpressionFactory.CastExpression arg) {
        return this.preExpression(arg);
    }

    @Override
    public void postCastExpression(ExpressionFactory.CastExpression arg) {
        this.bcu.emitCast(((ExpressionInternal)arg.expr()).type(), arg.type());
        this.postExpression(arg);
    }

    @Override
    public boolean preInstofExpression(ExpressionFactory.InstofExpression arg) {
        return this.preExpression(arg);
    }

    @Override
    public void postInstofExpression(ExpressionFactory.InstofExpression arg) {
        this.bcu.emitInstanceof(arg.itype());
        this.postExpression(arg);
    }

    @Override
    public boolean preStaticCallExpression(ExpressionFactory.StaticCallExpression arg) {
        return this.preExpression(arg);
    }

    @Override
    public void staticCallExpressionBeforeArg(ExpressionFactory.StaticCallExpression arg) {
    }

    @Override
    public void postStaticCallExpression(ExpressionFactory.StaticCallExpression arg) {
        this.bcu.emitStaticInvoke((Type)arg.target(), arg.ident(), arg.signature());
        this.postExpression(arg);
    }

    @Override
    public boolean preNonStaticCallExpression(ExpressionFactory.NonStaticCallExpression arg) {
        return this.preExpression(arg);
    }

    @Override
    public void nonStaticCallExpressionBeforeArg(ExpressionFactory.NonStaticCallExpression arg) {
    }

    @Override
    public void postNonStaticCallExpression(ExpressionFactory.NonStaticCallExpression arg) {
        this.bcu.emitInvoke(((ExpressionInternal)arg.target()).type(), arg.ident(), arg.signature());
        this.postExpression(arg);
    }

    @Override
    public boolean preNewObjExpression(ExpressionFactory.NewObjExpression arg) {
        this.bcu.emitNewCall(arg.type());
        return this.preExpression(arg);
    }

    @Override
    public void newObjExpressionBeforeArg(ExpressionFactory.NewObjExpression arg) {
    }

    @Override
    public void postNewObjExpression(ExpressionFactory.NewObjExpression arg) {
        this.bcu.emitNewInvoke(arg.type(), arg.signature());
        this.postExpression(arg);
    }

    @Override
    public boolean preNewArrExpression(ExpressionFactory.NewArrExpression arg) {
        return this.preExpression(arg);
    }

    @Override
    public void newArrExpressionAfterSize(ExpressionFactory.NewArrExpression arg) {
        this.bcu.emitNewArrayCall(arg.ctype());
    }

    @Override
    public void newArrExpressionBeforeExpression(ExpressionFactory.NewArrExpression arg) {
        this.bcu.emitDup();
        int ctr = ASMUtil.ctr.get(arg);
        this.bcu.emitConstantExpression(Type._int(), ctr);
        ASMUtil.ctr.set(arg, ++ctr);
    }

    @Override
    public void newArrExpressionAfterExpression(ExpressionFactory.NewArrExpression arg) {
        this.bcu.emitArrayStore();
    }

    @Override
    public void postNewArrExpression(ExpressionFactory.NewArrExpression arg) {
        this.postExpression(arg);
    }

    @Override
    public boolean preSuperCallExpression(ExpressionFactory.SuperCallExpression arg) {
        this.bcu.emitThisExpression();
        return this.preExpression(arg);
    }

    @Override
    public void superCallExpressionBeforeArg(ExpressionFactory.SuperCallExpression arg) {
    }

    @Override
    public void postSuperCallExpression(ExpressionFactory.SuperCallExpression arg) {
        Type superType = this.findClassGenerator(arg).superType();
        this.bcu.emitSpecialInvoke(superType, arg.ident(), arg.signature());
        this.postExpression(arg);
    }

    @Override
    public boolean preSuperObjExpression(ExpressionFactory.SuperObjExpression arg) {
        this.bcu.emitThisExpression();
        return this.preExpression(arg);
    }

    @Override
    public void superObjExpressionBeforeArg(ExpressionFactory.SuperObjExpression arg) {
    }

    @Override
    public void postSuperObjExpression(ExpressionFactory.SuperObjExpression arg) {
        Type superType = this.findClassGenerator(arg).superType();
        this.bcu.emitNewInvoke(superType, arg.signature());
        this.postExpression(arg);
    }

    @Override
    public boolean preThisObjExpression(ExpressionFactory.ThisObjExpression arg) {
        this.bcu.emitThisExpression();
        return this.preExpression(arg);
    }

    @Override
    public void thisObjExpressionBeforeArg(ExpressionFactory.ThisObjExpression arg) {
    }

    @Override
    public void postThisObjExpression(ExpressionFactory.ThisObjExpression arg) {
        Type type2 = this.findClassGenerator(arg).thisType();
        this.bcu.emitNewInvoke(type2, arg.signature());
        this.postExpression(arg);
    }

    @Override
    public boolean preNonStaticFieldAccessExpression(ExpressionFactory.NonStaticFieldAccessExpression arg) {
        return this.preExpression(arg);
    }

    @Override
    public void postNonStaticFieldAccessExpression(ExpressionFactory.NonStaticFieldAccessExpression arg) {
        EmitterFactory.Emitter emitter = ASMUtil.emitter.get(arg);
        this.bcu.callEmitter(emitter);
        this.postExpression(arg);
    }

    @Override
    public boolean preStaticFieldAccessExpression(ExpressionFactory.StaticFieldAccessExpression arg) {
        return this.preExpression(arg);
    }

    @Override
    public void postStaticFieldAccessExpression(ExpressionFactory.StaticFieldAccessExpression arg) {
        EmitterFactory.Emitter emitter = ASMUtil.emitter.get(arg);
        this.bcu.callEmitter(emitter);
        this.postExpression(arg);
    }

    @Override
    public boolean preArrayIndexExpression(ExpressionFactory.ArrayIndexExpression arg) {
        return this.preExpression(arg);
    }

    @Override
    public void postArrayIndexExpression(ExpressionFactory.ArrayIndexExpression arg) {
        EmitterFactory.Emitter emitter = ASMUtil.emitter.get(arg);
        this.bcu.callEmitter(emitter);
        this.postExpression(arg);
    }

    @Override
    public boolean preArrayLengthExpression(ExpressionFactory.ArrayLengthExpression arg) {
        return this.preExpression(arg);
    }

    @Override
    public void postArrayLengthExpression(ExpressionFactory.ArrayLengthExpression arg) {
        this.postExpression(arg);
        this.bcu.callEmitter(EmitterFactory.makeEmitter(arg));
    }

    @Override
    public boolean preIfExpression(ExpressionFactory.IfExpression arg) {
        return this.preExpression(arg);
    }

    @Override
    public void ifExpressionBeforeTruePart(ExpressionFactory.IfExpression arg) {
        this.bcu.emitConditionalBranch(ASMUtil.statementStartLabel.get((ExpressionInternal)arg.falsePart()));
    }

    @Override
    public boolean ifExpressionBeforeFalsePart(ExpressionFactory.IfExpression arg) {
        this.bcu.emitBranch(ASMByteCodeVisitor.nextLabel(arg));
        this.bcu.emitLabel(ASMUtil.statementStartLabel, (ExpressionInternal)arg.falsePart());
        return true;
    }

    @Override
    public void postIfExpression(ExpressionFactory.IfExpression arg) {
        this.postExpression(arg);
    }
}

