/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.net.URLPattern;
import com.sun.enterprise.web.WebContainer;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.glassfish.web.deployment.node.WebCommonNode;

public class ServletMappingNode
extends DeploymentDescriptorNode {
    private String servletName;
    private String urlPattern;

    @Override
    public Object getDescriptor() {
        return null;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("servlet-name".equals(element.getQName())) {
            this.servletName = value;
        }
        if ("url-pattern".equals(element.getQName())) {
            if (!URLPattern.isValid(value)) {
                Object parent;
                String trimmedUrl = value.trim();
                if ("\"\"".equals(trimmedUrl)) {
                    trimmedUrl = "";
                }
                if ((parent = this.getParentNode().getDescriptor()) instanceof WebBundleDescriptor && ((WebBundleDescriptor)parent).getSpecVersion().equals("2.2") && !trimmedUrl.startsWith("/") && !trimmedUrl.startsWith("*.")) {
                    trimmedUrl = "/" + trimmedUrl;
                }
                if (URLPattern.isValid(trimmedUrl)) {
                    if (URLPattern.containsCRorLF(value)) {
                        DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.urlcontainscrlf", new Object[]{value});
                    }
                    value = trimmedUrl;
                } else {
                    throw new IllegalArgumentException(WebContainer.rb.getString(MessageFormat.format("AS-WEB-GLUE-00279", value)));
                }
            }
            this.urlPattern = value;
            XMLNode parentNode = this.getParentNode();
            if (parentNode instanceof WebCommonNode) {
                ((WebCommonNode)parentNode).addServletMapping(this.servletName, this.urlPattern);
            } else {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{this.getXMLRootTag(), "servlet-mapping"});
            }
        }
    }
}

