/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.LifecycleCallbackInvoker;
import org.jboss.weld.interceptor.util.InterceptionUtils;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.security.GetAccessibleCopyOfMember;
import org.jboss.weld.util.BeanMethods;
import org.jboss.weld.util.Function;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.Iterables;

public class DefaultLifecycleCallbackInvoker<T>
implements LifecycleCallbackInvoker<T> {
    private static final Function<AnnotatedMethod<?>, Method> ACCESSIBLE_METHOD_FUNCTION = new Function<AnnotatedMethod<?>, Method>(){

        @Override
        @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
        public Method apply(AnnotatedMethod<?> method) {
            Preconditions.checkArgumentNotNull(method, "method");
            return AccessController.doPrivileged(new GetAccessibleCopyOfMember<Method>(method.getJavaMember()));
        }
    };
    private final List<Method> accessiblePostConstructMethods;
    private final List<Method> accessiblePreDestroyMethods;

    public static <T> DefaultLifecycleCallbackInvoker<T> of(EnhancedAnnotatedType<T> type2) {
        return new DefaultLifecycleCallbackInvoker<T>(type2);
    }

    public DefaultLifecycleCallbackInvoker(EnhancedAnnotatedType<T> type2) {
        this.accessiblePostConstructMethods = this.initMethodList(BeanMethods.getPostConstructMethods(type2));
        this.accessiblePreDestroyMethods = this.initMethodList(BeanMethods.getPreDestroyMethods(type2));
    }

    private List<Method> initMethodList(List<? extends AnnotatedMethod<?>> methods) {
        return ImmutableList.copyOf(Iterables.transform(methods, ACCESSIBLE_METHOD_FUNCTION));
    }

    @Override
    public void postConstruct(T instance, Instantiator<T> instantiator) {
        if (instantiator != null && instantiator.hasInterceptorSupport()) {
            InterceptionUtils.executePostConstruct(instance);
        } else {
            this.invokeMethods(this.accessiblePostConstructMethods, instance);
        }
    }

    @Override
    public void preDestroy(T instance, Instantiator<T> instantiator) {
        if (instantiator != null && instantiator.hasInterceptorSupport()) {
            InterceptionUtils.executePredestroy(instance);
        } else {
            this.invokeMethods(this.accessiblePreDestroyMethods, instance);
        }
    }

    private void invokeMethods(List<Method> methods, T instance) {
        for (Method method : methods) {
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw BeanLogger.LOG.invocationError(method, instance, e);
            }
        }
    }

    @Override
    public boolean hasPreDestroyMethods() {
        return !this.accessiblePreDestroyMethods.isEmpty();
    }

    @Override
    public boolean hasPostConstructMethods() {
        return !this.accessiblePostConstructMethods.isEmpty();
    }
}

