/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractHazelcastCacheManager;
import com.hazelcast.cache.impl.CacheDistributedObject;
import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.operation.CacheCreateConfigOperation;
import com.hazelcast.cache.impl.operation.CacheGetConfigOperation;
import com.hazelcast.cache.impl.operation.CacheManagementConfigOperation;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;

public class HazelcastServerCacheManager
extends AbstractHazelcastCacheManager {
    private final NodeEngine nodeEngine;
    private final ICacheService cacheService;

    public HazelcastServerCacheManager(HazelcastServerCachingProvider cachingProvider, HazelcastInstance hazelcastInstance, URI uri, ClassLoader classLoader, Properties properties) {
        super(cachingProvider, hazelcastInstance, uri, classLoader, properties);
        CacheDistributedObject setupRef = (CacheDistributedObject)hazelcastInstance.getDistributedObject("hz:impl:cacheService", "setupRef");
        this.nodeEngine = setupRef.getNodeEngine();
        this.cacheService = (ICacheService)setupRef.getService();
    }

    @Override
    public void enableManagement(String cacheName, boolean enabled) {
        this.checkIfManagerNotClosed();
        Preconditions.checkNotNull(cacheName, "cacheName cannot be null");
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        this.cacheService.setManagementEnabled(null, cacheNameWithPrefix, enabled);
        this.enableStatisticManagementOnOtherNodes(cacheName, false, enabled);
    }

    @Override
    public void enableStatistics(String cacheName, boolean enabled) {
        this.checkIfManagerNotClosed();
        Preconditions.checkNotNull(cacheName, "cacheName cannot be null");
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        this.cacheService.setStatisticsEnabled(null, cacheNameWithPrefix, enabled);
        this.enableStatisticManagementOnOtherNodes(cacheName, true, enabled);
    }

    private void enableStatisticManagementOnOtherNodes(String cacheName, boolean statOrMan, boolean enabled) {
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        ArrayList<Future> futures = new ArrayList<Future>();
        for (MemberImpl member : members) {
            if (member.localMember()) continue;
            CacheManagementConfigOperation op = new CacheManagementConfigOperation(cacheNameWithPrefix, statOrMan, enabled);
            InternalCompletableFuture future = this.nodeEngine.getOperationService().invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
            futures.add(future);
        }
        FutureUtil.waitWithDeadline(futures, 60L, TimeUnit.SECONDS);
    }

    @Override
    protected <K, V> CacheConfig<K, V> getCacheConfigLocal(String cacheName) {
        return this.cacheService.getCacheConfig(cacheName);
    }

    @Override
    protected <K, V> CacheConfig<K, V> createConfigOnPartition(CacheConfig<K, V> cacheConfig) {
        CacheCreateConfigOperation cacheCreateConfigOperation = new CacheCreateConfigOperation(cacheConfig);
        OperationService operationService = this.nodeEngine.getOperationService();
        int partitionId = this.nodeEngine.getPartitionService().getPartitionId(cacheConfig.getNameWithPrefix());
        InternalCompletableFuture f = operationService.invokeOnPartition("hz:impl:cacheService", cacheCreateConfigOperation, partitionId);
        return (CacheConfig)f.getSafely();
    }

    @Override
    protected <K, V> void addCacheConfigIfAbsent(CacheConfig<K, V> cacheConfig) {
        this.cacheService.createCacheConfigIfAbsent(cacheConfig);
    }

    @Override
    protected <K, V> CacheConfig<K, V> findConfig(String cacheName, String simpleCacheName, boolean createAlsoOnOthers, boolean syncCreate) {
        CacheConfig config = this.cacheService.getCacheConfig(cacheName);
        if (config == null) {
            CacheSimpleConfig simpleConfig = this.cacheService.findCacheConfig(simpleCacheName);
            if (simpleConfig != null) {
                try {
                    config = new CacheConfig(simpleConfig);
                    config.setName(simpleCacheName);
                    config.setManagerPrefix(cacheName.substring(0, cacheName.lastIndexOf(simpleCacheName)));
                }
                catch (Exception e) {
                    throw new CacheException(e);
                }
            }
            if (config == null) {
                config = this.getCacheConfigFromPartition(cacheName, simpleCacheName);
            }
            if (config != null) {
                this.createConfig(cacheName, config, createAlsoOnOthers, syncCreate);
            }
        }
        return config;
    }

    @Override
    protected <K, V> CacheConfig<K, V> createConfig(String cacheName, CacheConfig<K, V> config, boolean createAlsoOnOthers, boolean syncCreate) {
        CacheConfig currentCacheConfig = this.cacheService.getCacheConfig(cacheName);
        OperationService operationService = this.nodeEngine.getOperationService();
        CacheCreateConfigOperation op = new CacheCreateConfigOperation(config, createAlsoOnOthers);
        InternalCompletableFuture future = operationService.invokeOnTarget("hz:impl:cacheService", op, this.nodeEngine.getThisAddress());
        if (syncCreate) {
            return (CacheConfig)future.getSafely();
        }
        return currentCacheConfig;
    }

    @Override
    protected <K, V> ICacheInternal<K, V> createCacheProxy(CacheConfig<K, V> cacheConfig) {
        return new CacheProxy(cacheConfig, this.nodeEngine, this.cacheService, this);
    }

    @Override
    protected <K, V> CacheConfig<K, V> getCacheConfigFromPartition(String cacheNameWithPrefix, String cacheName) {
        CacheGetConfigOperation op = new CacheGetConfigOperation(cacheNameWithPrefix, cacheName);
        int partitionId = this.nodeEngine.getPartitionService().getPartitionId(cacheNameWithPrefix);
        InternalCompletableFuture f = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:cacheService", op, partitionId);
        return (CacheConfig)f.getSafely();
    }

    @Override
    protected void removeCacheConfigFromLocal(String cacheName) {
        this.cacheService.deleteCacheConfig(cacheName);
        super.removeCacheConfigFromLocal(cacheName);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (HazelcastServerCacheManager.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void postClose() {
        if (this.properties.getProperty("hazelcast.config.location") != null) {
            this.hazelcastInstance.shutdown();
        }
    }

    public ICacheService getCacheService() {
        return this.cacheService;
    }
}

