/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleProbe;
import com.hazelcast.internal.metrics.Gauge;
import com.hazelcast.internal.metrics.LongProbe;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.impl.GaugeImpl;
import com.hazelcast.internal.metrics.impl.SourceMetadata;
import com.hazelcast.internal.metrics.metricsets.ClassLoadingMetricSet;
import com.hazelcast.internal.metrics.metricsets.GarbageCollectionMetricSet;
import com.hazelcast.internal.metrics.metricsets.OperatingSystemMetricsSet;
import com.hazelcast.internal.metrics.metricsets.RuntimeMetricSet;
import com.hazelcast.internal.metrics.metricsets.ThreadMetricSet;
import com.hazelcast.logging.ILogger;
import com.hazelcast.util.Preconditions;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MetricsRegistryImpl
implements MetricsRegistry {
    private final ILogger logger;
    private final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(2);
    private final AtomicInteger modCount = new AtomicInteger();
    private final ConcurrentMap<String, GaugeImpl> metrics = new ConcurrentHashMap<String, GaugeImpl>();
    private final ConcurrentMap<Class<?>, SourceMetadata> metadataMap = new ConcurrentHashMap();

    public MetricsRegistryImpl(ILogger logger2) {
        this.logger = Preconditions.checkNotNull(logger2, "Logger can't be null");
        RuntimeMetricSet.register(this);
        GarbageCollectionMetricSet.register(this);
        OperatingSystemMetricsSet.register(this);
        ThreadMetricSet.register(this);
        ClassLoadingMetricSet.register(this);
    }

    @Override
    public int modCount() {
        return this.modCount.get();
    }

    @Override
    public Set<String> getNames() {
        return this.metrics.keySet();
    }

    SourceMetadata getObjectMetadata(Class<?> clazz) {
        SourceMetadata metadata = (SourceMetadata)this.metadataMap.get(clazz);
        if (metadata == null) {
            metadata = new SourceMetadata(clazz);
            SourceMetadata found = this.metadataMap.putIfAbsent(clazz, metadata);
            metadata = found == null ? metadata : found;
        }
        return metadata;
    }

    @Override
    public synchronized <S> void scanAndRegister(S source, String namePrefix) {
        Preconditions.checkNotNull(source, "source can't be null");
        Preconditions.checkNotNull(namePrefix, "namePrefix can't be null");
        SourceMetadata metadata = this.getObjectMetadata(source.getClass());
        metadata.register(this, source, namePrefix);
    }

    @Override
    public synchronized <S> void register(S source, String name, LongProbe<S> input) {
        Preconditions.checkNotNull(name, "source can't be null");
        Preconditions.checkNotNull(name, "name can't be null");
        Preconditions.checkNotNull(name, "input can't be null");
        this.registerInternal(source, name, input);
    }

    @Override
    public synchronized <S> void register(S source, String name, DoubleProbe<S> input) {
        Preconditions.checkNotNull(name, "source can't be null");
        Preconditions.checkNotNull(name, "name can't be null");
        Preconditions.checkNotNull(name, "input can't be null");
        this.registerInternal(source, name, input);
    }

    <S> void registerInternal(S source, String name, Object input) {
        GaugeImpl gauge = (GaugeImpl)this.metrics.get(name);
        if (gauge == null) {
            gauge = new GaugeImpl(name, this.logger);
            this.metrics.put(name, gauge);
        }
        this.logOverwrite(name, gauge);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Registered gauge " + name);
        }
        gauge.source = source;
        gauge.input = input;
        this.modCount.incrementAndGet();
    }

    private void logOverwrite(String name, GaugeImpl gauge) {
        if (gauge.input != null) {
            this.logger.warning(String.format("Duplicate registration, a input for Metric '%s' already exists", name));
        }
        if (gauge.source != null) {
            this.logger.warning(String.format("Duplicate registration, a input for Metric '%s' already exists", name));
        }
    }

    @Override
    public synchronized Gauge getGauge(String name) {
        Preconditions.checkNotNull(name, "name can't be null");
        GaugeImpl gauge = (GaugeImpl)this.metrics.get(name);
        if (gauge == null) {
            gauge = new GaugeImpl(name, this.logger);
            this.metrics.put(name, gauge);
        }
        return gauge;
    }

    @Override
    public synchronized <S> void deregister(S source) {
        Preconditions.checkNotNull(source, "source can't be null");
        boolean changed = false;
        for (Map.Entry entry : this.metrics.entrySet()) {
            GaugeImpl gauge = (GaugeImpl)entry.getValue();
            if (gauge.source != source) continue;
            String name = (String)entry.getKey();
            changed = true;
            this.metrics.remove(name);
            gauge.source = null;
            gauge.input = null;
            if (!this.logger.isFinestEnabled()) continue;
            this.logger.finest("Destroying gauge " + name);
        }
        if (changed) {
            this.modCount.incrementAndGet();
        }
    }

    @Override
    public void scheduleAtFixedRate(Runnable publisher, long period, TimeUnit timeUnit) {
        this.scheduledExecutorService.scheduleAtFixedRate(publisher, 0L, period, timeUnit);
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }
}

