/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.IFunction;
import com.hazelcast.map.impl.MapKeyLoaderUtil;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.operation.LoadAllOperation;
import com.hazelcast.map.impl.operation.LoadStatusOperation;
import com.hazelcast.map.impl.operation.PartitionCheckIfLoadedOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.AbstractCompletableFuture;
import com.hazelcast.util.IterableUtil;
import com.hazelcast.util.StateMachine;
import com.hazelcast.util.scheduler.CoalescingDelayedTrigger;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MapKeyLoader {
    private static final long LOADING_TRIGGER_DELAY = TimeUnit.SECONDS.toMillis(5L);
    private String mapName;
    private OperationService opService;
    private InternalPartitionService partitionService;
    private IFunction<Object, Data> toData;
    private ExecutionService execService;
    private CoalescingDelayedTrigger deleayedTrigger;
    private int maxSizePerNode;
    private int maxBatch;
    private int mapNamePartition;
    private boolean hasBackup;
    private LoadFinishedFuture loadFinished = new LoadFinishedFuture(true);
    private final StateMachine<Role> role = StateMachine.of(Role.NONE).withTransition(Role.NONE, Role.SENDER, new Role[]{Role.RECEIVER, Role.SENDER_BACKUP}).withTransition(Role.SENDER_BACKUP, Role.SENDER, new Role[0]);
    private final StateMachine<State> state = StateMachine.of(State.NOT_LOADED).withTransition(State.NOT_LOADED, State.LOADING, new State[0]).withTransition(State.LOADING, State.LOADED, new State[]{State.NOT_LOADED}).withTransition(State.LOADED, State.LOADING, new State[0]);

    public MapKeyLoader(String mapName, OperationService opService, InternalPartitionService ps, ExecutionService execService, IFunction<Object, Data> serialize) {
        this.mapName = mapName;
        this.opService = opService;
        this.partitionService = ps;
        this.toData = serialize;
        this.execService = execService;
    }

    public Future startInitialLoad(MapStoreContext mapStoreContext, int partitionId) {
        this.mapNamePartition = this.partitionService.getPartitionId(this.toData.apply(this.mapName));
        Role newRole = MapKeyLoaderUtil.assignRole(this.partitionService, this.mapNamePartition, partitionId);
        this.role.nextOrStay(newRole);
        this.state.next(State.LOADING);
        switch (newRole) {
            case SENDER: {
                return this.sendKeys(mapStoreContext, false);
            }
            case SENDER_BACKUP: 
            case RECEIVER: {
                return this.triggerLoading();
            }
        }
        return this.loadFinished;
    }

    public Future<?> sendKeys(final MapStoreContext mapStoreContext, final boolean replaceExistingValues) {
        if (this.loadFinished.isDone()) {
            this.loadFinished = new LoadFinishedFuture();
            Future<Boolean> sent = this.execService.submit("hz:map-loadAllKeys", new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    MapKeyLoader.this.sendKeysInBatches(mapStoreContext, replaceExistingValues);
                    return false;
                }
            });
            this.execService.asCompletableFuture(sent).andThen(this.loadFinished);
        }
        return this.loadFinished;
    }

    public Future triggerLoading() {
        if (this.loadFinished.isDone()) {
            this.loadFinished = new LoadFinishedFuture();
            this.execService.execute("hz:map-loadAllKeys", new Runnable(){

                @Override
                public void run() {
                    PartitionCheckIfLoadedOperation op = new PartitionCheckIfLoadedOperation(MapKeyLoader.this.mapName, true);
                    MapKeyLoader.this.opService.invokeOnPartition("hz:impl:mapService", op, MapKeyLoader.this.mapNamePartition).andThen(MapKeyLoader.this.ifLoadedCallback());
                }
            });
        }
        return this.loadFinished;
    }

    public Future<?> startLoading(MapStoreContext mapStoreContext, boolean replaceExistingValues) {
        this.role.nextOrStay(Role.SENDER);
        if (this.state.is(State.LOADING, new State[0])) {
            return this.loadFinished;
        }
        this.state.next(State.LOADING);
        return this.sendKeys(mapStoreContext, replaceExistingValues);
    }

    public void trackLoading(boolean lastBatch, Throwable exception) {
        if (lastBatch) {
            this.state.nextOrStay(State.LOADED);
            if (exception != null) {
                this.loadFinished.setResult(exception);
            } else {
                this.loadFinished.setResult(true);
            }
        } else if (this.state.is(State.LOADED, new State[0])) {
            this.state.next(State.LOADING);
        }
    }

    public void triggerLoadingWithDelay() {
        if (this.deleayedTrigger == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PartitionCheckIfLoadedOperation op = new PartitionCheckIfLoadedOperation(MapKeyLoader.this.mapName, true);
                    MapKeyLoader.this.opService.invokeOnPartition("hz:impl:mapService", op, MapKeyLoader.this.mapNamePartition);
                }
            };
            this.deleayedTrigger = new CoalescingDelayedTrigger(this.execService, LOADING_TRIGGER_DELAY, LOADING_TRIGGER_DELAY, runnable);
        }
        this.deleayedTrigger.executeWithDelay();
    }

    public boolean shouldDoInitialLoad() {
        if (this.role.is(Role.SENDER_BACKUP, new Role[0])) {
            this.role.next(Role.SENDER);
            if (this.state.is(State.LOADING, new State[0])) {
                this.state.next(State.NOT_LOADED);
                this.loadFinished.setResult(false);
            }
        }
        return this.state.is(State.NOT_LOADED, new State[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendKeysInBatches(MapStoreContext mapStoreContext, boolean replaceExistingValues) {
        int clusterSize = this.partitionService.getMemberPartitionsMap().size();
        Iterator<Object> keys = null;
        Exception loadError = null;
        try {
            Iterable<Object> allKeys = mapStoreContext.loadAllKeys();
            keys = allKeys.iterator();
            Iterator<Data> dataKeys = IterableUtil.map(keys, this.toData);
            int mapMaxSize = clusterSize * this.maxSizePerNode;
            if (mapMaxSize > 0) {
                dataKeys = IterableUtil.limit(dataKeys, mapMaxSize);
            }
            Iterator<Map.Entry<Integer, Data>> partitionsAndKeys = IterableUtil.map(dataKeys, MapKeyLoaderUtil.toPartition(this.partitionService));
            Iterator<Map<Integer, List<Data>>> batches = MapKeyLoaderUtil.toBatches(partitionsAndKeys, this.maxBatch);
            while (batches.hasNext()) {
                Map<Integer, List<Data>> batch = batches.next();
                this.sendBatch(batch, replaceExistingValues);
            }
        }
        catch (Exception caught) {
            loadError = caught;
        }
        finally {
            this.sendLoadCompleted(clusterSize, this.partitionService.getPartitionCount(), replaceExistingValues, loadError);
            if (keys instanceof Closeable) {
                IOUtil.closeResource((Closeable)((Object)keys));
            }
        }
    }

    private void sendBatch(Map<Integer, List<Data>> batch, boolean replaceExistingValues) {
        for (Map.Entry<Integer, List<Data>> e : batch.entrySet()) {
            int partitionId = e.getKey();
            List<Data> keys = e.getValue();
            LoadAllOperation op = new LoadAllOperation(this.mapName, keys, replaceExistingValues);
            this.opService.invokeOnPartition("hz:impl:mapService", op, partitionId);
        }
    }

    private void sendLoadCompleted(int clusterSize, int partitions, boolean replaceExistingValues, Throwable exception) {
        for (int partitionId = 0; partitionId < partitions; ++partitionId) {
            LoadStatusOperation op = new LoadStatusOperation(this.mapName, exception);
            this.opService.invokeOnPartition("hz:impl:mapService", op, partitionId);
        }
        if (this.hasBackup && clusterSize > 1) {
            LoadStatusOperation op = new LoadStatusOperation(this.mapName, exception);
            this.opService.createInvocationBuilder("hz:impl:mapService", (Operation)op, this.mapNamePartition).setReplicaIndex(1).invoke();
        }
    }

    public void setMaxBatch(int maxBatch) {
        this.maxBatch = maxBatch;
    }

    public void setMaxSize(int maxSize) {
        this.maxSizePerNode = maxSize;
    }

    public void setHasBackup(boolean hasBackup) {
        this.hasBackup = hasBackup;
    }

    private ExecutionCallback<Boolean> ifLoadedCallback() {
        return new ExecutionCallback<Boolean>(){

            @Override
            public void onResponse(Boolean loaded) {
                if (loaded.booleanValue()) {
                    MapKeyLoader.this.state.nextOrStay(State.LOADED);
                    MapKeyLoader.this.loadFinished.setResult(true);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                MapKeyLoader.this.loadFinished.setResult(t);
            }
        };
    }

    private static final class LoadFinishedFuture
    extends AbstractCompletableFuture<Boolean>
    implements ExecutionCallback<Boolean> {
        private LoadFinishedFuture(Boolean result) {
            this();
            this.setResult(result);
        }

        private LoadFinishedFuture() {
            super((Executor)null, null);
        }

        @Override
        public Boolean get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.isDone()) {
                return (Boolean)this.getResult();
            }
            throw new UnsupportedOperationException("Future is not done yet");
        }

        @Override
        public void onResponse(Boolean loaded) {
            if (loaded.booleanValue()) {
                this.setResult(loaded);
            }
        }

        @Override
        public void onFailure(Throwable t) {
            this.setResult(t);
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{done=" + this.isDone() + "}";
        }
    }

    static enum State {
        NOT_LOADED,
        LOADING,
        LOADED;

    }

    static enum Role {
        NONE,
        SENDER,
        RECEIVER,
        SENDER_BACKUP;

    }
}

