/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.core.TransactionalMap;
import com.hazelcast.map.impl.MapKeySet;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.MapValueCollection;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.client.BaseTransactionRequest;
import java.io.IOException;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class AbstractTxnMapRequest
extends BaseTransactionRequest {
    String name;
    TxnMapRequestType requestType;
    Data key;
    Data value;
    Data newValue;
    long ttl = -1L;

    public AbstractTxnMapRequest() {
    }

    public AbstractTxnMapRequest(String name, TxnMapRequestType requestType) {
        this.name = name;
        this.requestType = requestType;
    }

    public AbstractTxnMapRequest(String name, TxnMapRequestType requestType, Data key) {
        this(name, requestType);
        this.key = key;
    }

    public AbstractTxnMapRequest(String name, TxnMapRequestType requestType, Data key, Data value) {
        this(name, requestType, key);
        this.value = value;
    }

    public AbstractTxnMapRequest(String name, TxnMapRequestType requestType, Data key, Data value, Data newValue) {
        this(name, requestType, key, value);
        this.newValue = newValue;
    }

    public AbstractTxnMapRequest(String name, TxnMapRequestType requestType, Data key, Data value, long ttl, TimeUnit timeUnit) {
        this(name, requestType, key, value);
        this.ttl = timeUnit == null ? ttl : timeUnit.toMillis(ttl);
    }

    @Override
    public Object innerCall() throws Exception {
        TransactionContext context = this.getEndpoint().getTransactionContext(this.txnId);
        TransactionalMap map = context.getMap(this.name);
        return this.innerCallInternal(map);
    }

    private Object innerCallInternal(TransactionalMap map) {
        Object result = null;
        switch (this.requestType) {
            case CONTAINS_KEY: {
                result = map.containsKey(this.key);
                break;
            }
            case GET: {
                result = map.get(this.key);
                break;
            }
            case GET_FOR_UPDATE: {
                result = map.getForUpdate(this.key);
                break;
            }
            case SIZE: {
                result = map.size();
                break;
            }
            case PUT: {
                result = map.put(this.key, this.value);
                break;
            }
            case PUT_WITH_TTL: {
                result = map.put(this.key, this.value, this.ttl, TimeUnit.MILLISECONDS);
                break;
            }
            case PUT_IF_ABSENT: {
                result = map.putIfAbsent(this.key, this.value);
                break;
            }
            case REPLACE: {
                result = map.replace(this.key, this.value);
                break;
            }
            case REPLACE_IF_SAME: {
                result = map.replace(this.key, this.value, this.newValue);
                break;
            }
            case SET: {
                map.set(this.key, this.value);
                break;
            }
            case REMOVE: {
                result = map.remove(this.key);
                break;
            }
            case DELETE: {
                map.delete(this.key);
                break;
            }
            case REMOVE_IF_SAME: {
                result = map.remove(this.key, this.value);
                break;
            }
            case KEYSET: {
                result = this.getMapKeySet(map.keySet());
                break;
            }
            case KEYSET_BY_PREDICATE: {
                result = this.getMapKeySet(map.keySet(this.getPredicate()));
                break;
            }
            case VALUES: {
                result = this.getMapValueCollection(map.values());
                break;
            }
            case VALUES_BY_PREDICATE: {
                result = this.getMapValueCollection(map.values(this.getPredicate()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a known TxnMapRequestType [" + (Object)((Object)this.requestType) + "]");
            }
        }
        return result;
    }

    private MapKeySet getMapKeySet(Set keySet) {
        HashSet<Data> dataKeySet = new HashSet<Data>();
        for (Object key : keySet) {
            Object dataKey = this.serializationService.toData(key);
            dataKeySet.add((Data)dataKey);
        }
        return new MapKeySet(dataKeySet);
    }

    private MapValueCollection getMapValueCollection(Collection coll) {
        HashSet<Data> valuesCollection = new HashSet<Data>(coll.size());
        for (Object value : coll) {
            Object dataValue = this.serializationService.toData(value);
            valuesCollection.add((Data)dataValue);
        }
        return new MapValueCollection(valuesCollection);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.name);
        writer.writeInt("t", this.requestType.type);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
        out.writeData(this.value);
        out.writeData(this.newValue);
        this.writeDataInner(out);
        out.writeLong(this.ttl);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("n");
        this.requestType = TxnMapRequestType.getByType(reader.readInt("t"));
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
        this.value = in.readData();
        this.newValue = in.readData();
        this.readDataInner(in);
        this.ttl = in.readLong();
    }

    protected abstract Predicate getPredicate();

    protected abstract void writeDataInner(ObjectDataOutput var1) throws IOException;

    protected abstract void readDataInner(ObjectDataInput var1) throws IOException;

    @Override
    public Permission getRequiredPermission() {
        return this.requestType.getRequiredPermission(this.name);
    }

    public static enum TxnMapRequestType {
        CONTAINS_KEY(1){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapReadPermission(name);
            }
        }
        ,
        GET(2){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapReadPermission(name);
            }
        }
        ,
        SIZE(3){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapReadPermission(name);
            }
        }
        ,
        PUT(4){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapLockedWritePermission(name);
            }
        }
        ,
        PUT_IF_ABSENT(5){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapLockedWritePermission(name);
            }
        }
        ,
        REPLACE(6){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapLockedWritePermission(name);
            }
        }
        ,
        REPLACE_IF_SAME(7){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapLockedWritePermission(name);
            }
        }
        ,
        SET(8){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapLockedWritePermission(name);
            }
        }
        ,
        REMOVE(9){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapLockedRemovePermission(name);
            }
        }
        ,
        DELETE(10){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapLockedRemovePermission(name);
            }
        }
        ,
        REMOVE_IF_SAME(11){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapLockedRemovePermission(name);
            }
        }
        ,
        KEYSET(12){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapReadPermission(name);
            }
        }
        ,
        KEYSET_BY_PREDICATE(13){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapReadPermission(name);
            }
        }
        ,
        VALUES(14){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapReadPermission(name);
            }
        }
        ,
        VALUES_BY_PREDICATE(15){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapReadPermission(name);
            }
        }
        ,
        GET_FOR_UPDATE(16){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapLockedReadPermission(name);
            }
        }
        ,
        PUT_WITH_TTL(17){

            @Override
            Permission getRequiredPermission(String name) {
                return TxnMapRequestType.getMapLockedWritePermission(name);
            }
        };

        int type;

        private TxnMapRequestType(int i) {
            this.type = i;
        }

        public static TxnMapRequestType getByType(int type2) {
            for (TxnMapRequestType requestType : TxnMapRequestType.values()) {
                if (requestType.type != type2) continue;
                return requestType;
            }
            return null;
        }

        abstract Permission getRequiredPermission(String var1);

        private static Permission getMapReadPermission(String name) {
            return new MapPermission(name, "read");
        }

        private static Permission getMapLockedReadPermission(String name) {
            return new MapPermission(name, "read", "lock");
        }

        private static Permission getMapLockedWritePermission(String name) {
            return new MapPermission(name, "put", "lock");
        }

        private static Permission getMapLockedRemovePermission(String name) {
            return new MapPermission(name, "remove", "lock");
        }
    }
}

