/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="version")
@PerLookup
public class VersionCommand
extends CLICommand {
    @Param(optional=true, shortName="v")
    private boolean verbose;
    @Param(optional=true)
    private boolean local;
    @Param(optional=true)
    private boolean terse;
    private static final LocalStringsImpl strings = new LocalStringsImpl(VersionCommand.class);

    @Override
    protected int executeCommand() throws CommandException {
        if (this.local) {
            this.invokeLocal();
            return 0;
        }
        try {
            RemoteCLICommand cmd = new RemoteCLICommand("version", this.programOpts, this.env);
            String version = this.verbose ? cmd.executeAndReturnOutput("version", "--verbose") : cmd.executeAndReturnOutput("version");
            version = version.trim();
            logger.info(this.terse ? version : strings.get("version.remote", version));
        }
        catch (Exception e) {
            this.printRemoteException(e);
            this.invokeLocal();
        }
        return 0;
    }

    private void invokeLocal() {
        String fv = Version.getFullVersion();
        logger.info(this.terse ? fv : strings.get("version.local", fv));
        if (this.verbose) {
            logger.info(strings.get("version.local.java", System.getProperty("java.version")));
        }
    }

    private void printRemoteException(Exception e) {
        logger.info(strings.get("remote.version.failed", this.programOpts.getHost(), this.programOpts.getPort() + ""));
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(e.getMessage());
        } else {
            logger.info(strings.get("remote.version.failed.debug", Environment.getDebugVar()));
        }
    }
}

