/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.io.DomainDirs;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;

public abstract class BackupCommands
extends LocalDomainCommand {
    BackupRequest request;
    private static final LocalStringsImpl strings = new LocalStringsImpl(BackupCommands.class);
    @Param(name="long", shortName="l", alias="verbose", optional=true)
    boolean verbose;
    @Param(name="domain_name", primary=true, optional=true)
    String domainName;
    @Param(name="_configonly", optional=true)
    String configonly;
    @Param(optional=true)
    String backupConfig;
    @Param(optional=true)
    String backupdir;
    private String desc = null;
    private int recycleLimit = 0;

    protected void checkOptions() throws CommandException {
        File domainsDirFile;
        if (this.verbose && this.programOpts.isTerse()) {
            throw new CommandValidationException(strings.get("NoVerboseAndTerseAtTheSameTime"));
        }
        if (this.domainDirParam == null || this.domainDirParam.length() <= 0) {
            try {
                this.domainDirParam = DomainDirs.getDefaultDomainsDir().getPath();
            }
            catch (IOException ioe) {
                throw new CommandException(ioe.getMessage());
            }
        }
        if (!(domainsDirFile = new File(this.domainDirParam)).isDirectory()) {
            throw new CommandValidationException(strings.get("InvalidDomainPath", this.domainDirParam));
        }
        if (this.domainName == null) {
            this.domainName = this.getDomainName();
        }
    }

    protected void setDescription(String d) {
        this.desc = d;
    }

    protected void setBackupDir(String dir) {
        this.backupdir = dir;
    }

    protected void setRecycleLimit(int limit) {
        this.recycleLimit = limit;
    }

    protected void prepareRequest() throws CommandValidationException {
        File backupdir_f = null;
        if (this.backupdir != null && !(backupdir_f = new File(this.backupdir)).isAbsolute()) {
            throw new CommandValidationException(strings.get("InvalidBackupDirPath", this.backupdir));
        }
        boolean configonlybackup = false;
        if (this.configonly != null && Boolean.valueOf(this.configonly).booleanValue()) {
            configonlybackup = true;
        }
        this.request = new BackupRequest(this.domainDirParam, this.domainName, backupdir_f, this.backupConfig, this.desc, this.recycleLimit, configonlybackup);
        this.request.setTerse(this.programOpts.isTerse());
        this.request.setVerbose(this.verbose);
    }

    protected boolean isWritableDirectory(File domainFile) {
        boolean result = false;
        if (domainFile.isDirectory() || domainFile.canWrite()) {
            result = true;
        }
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + ObjectAnalyzer.toString(this);
    }
}

