/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.optional.BackupCommands;
import com.sun.enterprise.admin.cli.optional.BackupDomainCommand;
import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.backup.BackupWarningException;
import com.sun.enterprise.backup.RestoreManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.ObjectAnalyzer;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="restore-domain")
@PerLookup
public final class RestoreDomainCommand
extends BackupCommands {
    @Param(name="filename", optional=true)
    private String backupFilename;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    @Param(name="description", optional=true, obsolete=true)
    private String description;
    private static final LocalStringsImpl strings = new LocalStringsImpl(BackupDomainCommand.class);

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        boolean domainExists = true;
        if (this.backupFilename == null && this.domainName == null) {
            if (!this.force) {
                throw new CommandException(strings.get("UseForceOption"));
            }
            super.validate();
        }
        this.checkOptions();
        try {
            this.setDomainName(this.domainName);
            this.initDomain();
        }
        catch (CommandException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                domainExists = false;
            }
            throw e;
        }
        if (domainExists && this.isRunning()) {
            throw new CommandException(strings.get("DomainIsNotStopped", this.domainName));
        }
        if (this.backupFilename != null) {
            File f = new File(this.backupFilename);
            if (!f.exists()) {
                throw new CommandValidationException(strings.get("FileDoesNotExist", this.backupFilename));
            }
            if (!f.canRead()) {
                throw new CommandValidationException(strings.get("FileCanNotRead", this.backupFilename));
            }
            if (f.isDirectory()) {
                throw new CommandValidationException(strings.get("FileIsDirectory", this.backupFilename));
            }
        }
        this.setBackupDir(this.backupdir);
        this.initRequest();
        this.initializeLogger();
    }

    @Override
    protected int executeCommand() throws CommandException {
        try {
            RestoreManager mgr = new RestoreManager(this.request);
            logger.info(mgr.restore());
        }
        catch (BackupWarningException bwe) {
            logger.info(bwe.getMessage());
        }
        catch (BackupException be) {
            throw new CommandException(be);
        }
        return 0;
    }

    private void initRequest() throws CommandValidationException {
        File backupdir_f = null;
        if (this.backupdir != null && !(backupdir_f = new File(this.backupdir)).isAbsolute()) {
            throw new CommandValidationException(strings.get("InvalidBackupDirPath", this.backupdir));
        }
        boolean configonlybackup = false;
        if (this.configonly != null && Boolean.valueOf(this.configonly).booleanValue()) {
            configonlybackup = true;
        }
        this.request = new BackupRequest(this.domainDirParam, this.domainName, backupdir_f, this.backupConfig, this.backupFilename, configonlybackup);
        this.request.setTerse(this.programOpts.isTerse());
        this.request.setVerbose(this.verbose);
        this.request.setForce(this.force);
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + ObjectAnalyzer.toString(this);
    }
}

