/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.pe;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.servermgmt.pe.PEScriptsTokens;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.BitSet;

public class PEDomainsManager
extends RepositoryManager
implements DomainsManager {
    private static final StringManager strMgr = StringManager.getManager(PEDomainsManager.class);
    public static final String PROFILEPROPERTY_DOMAINXML_STYLESHEETS = "domain.xml.style-sheets";
    public static final String PROFILEPROPERTY_DOMAINXML_TOKENVALUES = "domain.xml.token-values";

    @Override
    public BitSet getDomainFlags() {
        BitSet bs = new BitSet();
        bs.set(1, false);
        return bs;
    }

    @Override
    public void validateDomain(DomainConfig domainConfig, boolean domainExists) throws DomainException {
        try {
            this.checkRepository(domainConfig, domainExists, domainExists);
        }
        catch (RepositoryException ex) {
            throw new DomainException(ex);
        }
    }

    @Override
    public void validateMasterPassword(DomainConfig domainConfig) throws DomainException {
        try {
            this.validateMasterPassword(domainConfig, PEDomainsManager.getMasterPasswordClear(domainConfig));
        }
        catch (RepositoryException ex) {
            throw new DomainException(ex);
        }
    }

    protected void createJBIInstance(String instanceName, DomainConfig domainConfig) throws DomainException {
        try {
            this.getFileLayout(domainConfig).createJBIDomainDirectories();
            super.createJBIInstance(instanceName, domainConfig);
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
    }

    @Override
    public void deleteDomain(DomainConfig domainConfig) throws DomainException {
        try {
            this.deleteRepository(domainConfig);
        }
        catch (Exception e) {
            throw new DomainException(e);
        }
    }

    @Override
    public String[] listDomains(DomainConfig domainConfig) throws DomainException {
        try {
            return this.listRepository(domainConfig);
        }
        catch (Exception e) {
            throw new DomainException(e);
        }
    }

    protected void createScripts(DomainConfig domainConfig) throws DomainException {
        TokenValueSet tokens = PEScriptsTokens.getTokenValueSet(domainConfig);
        this.createStartServ(domainConfig, tokens);
        this.createStopServ(domainConfig, tokens);
    }

    void createStartServ(DomainConfig domainConfig, TokenValueSet tokens) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File startServTemplate = layout.getStartServTemplate();
            File startServ = layout.getStartServ();
            this.generateFromTemplate(tokens, startServTemplate, startServ);
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("startServNotCreated"), e);
        }
    }

    void createStopServ(DomainConfig domainConfig, TokenValueSet tokens) throws DomainException {
        try {
            PEFileLayout layout = this.getFileLayout(domainConfig);
            File stopServTemplate = layout.getStopServTemplate();
            File stopServ = layout.getStopServ();
            this.generateFromTemplate(tokens, stopServTemplate, stopServ);
        }
        catch (Exception e) {
            throw new DomainException(strMgr.getString("stopServNotCreated"), e);
        }
    }

    protected File getDomainDir(DomainConfig domainConfig) {
        return this.getRepositoryDir(domainConfig);
    }

    protected File getDomainRoot(DomainConfig domainConfig) {
        return this.getRepositoryRootDir(domainConfig);
    }

    String getDefaultInstance() {
        return "server";
    }

    protected static String getDomainUser(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.user");
    }

    protected static String getDomainPasswordClear(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.password");
    }

    protected static String getMasterPasswordClear(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.masterPassword");
    }

    protected static String getNewMasterPasswordClear(DomainConfig domainConfig) {
        return (String)domainConfig.get("domain.newMasterPassword");
    }

    protected static boolean saveMasterPassword(DomainConfig domainConfig) {
        Boolean b = (Boolean)domainConfig.get("domain.saveMasterPassword");
        return b;
    }

    public void changeMasterPassword(DomainConfig config) throws DomainException {
        try {
            String oldPass = PEDomainsManager.getMasterPasswordClear(config);
            String newPass = PEDomainsManager.getNewMasterPasswordClear(config);
            this.changePasswordAliasKeystorePassword(config, oldPass, newPass);
            this.changeSSLCertificateDatabasePassword(config, oldPass, newPass);
            this.changeMasterPasswordInMasterPasswordFile(config, newPass, PEDomainsManager.saveMasterPassword(config));
        }
        catch (Exception ex) {
            throw new DomainException(strMgr.getString("masterPasswordNotChanged"), ex);
        }
    }

    @Override
    public String[] getExtraPasswordOptions(DomainConfig config) throws DomainException {
        return null;
    }
}

