/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.services;

import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.ServiceAdapter;
import com.sun.enterprise.admin.servermgmt.services.ServicesUtils;
import com.sun.enterprise.admin.servermgmt.services.Strings;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public final class SMFService
extends ServiceAdapter {
    public static final String TIMEOUT_SECONDS_DV = "0";
    public static final String AS_ADMIN_USER_DEF_VAL = "admin";
    public static final String SP_DELIMITER = ":";
    public static final String PRIVILEGES_DEFAULT_VAL = "basic";
    public static final String NETADDR_PRIV_VAL = "net_privaddr";
    public static final String BASIC_NETADDR_PRIV_VAL = "basic,net_privaddr";
    public static final String START_INSTANCES_TN = "START_INSTANCES";
    public static final String START_INSTANCES_DEFAULT_VAL = Boolean.TRUE.toString();
    public static final String NO_START_INSTANCES_PROPERTY = "startinstances=false";
    public static final String SVCCFG = "/usr/sbin/svccfg";
    public static final String SVCADM = "/usr/sbin/svcadm";
    public static final String MANIFEST_HOME = "/var/svc/manifest/application/GlassFish/";
    private static final String NULL_VALUE = "null";
    private static final StringManager sm = StringManager.getManager(SMFService.class);
    private static final String nullArgMsg = sm.getString("null_arg");
    private static final String MANIFEST_FILE_SUFFIX = "Domain-service-smf.xml";
    private static final String MANIFEST_FILE_TEMPL_SUFFIX = "Domain-service-smf.xml.template";
    private static final String REL_PATH_TEMPLATES = "lib/install/templates";

    SMFService(ServerDirs dirs, AppserverServiceType type2) {
        super(dirs, type2);
        if (!SMFService.apropos()) {
            throw new IllegalArgumentException("Internal Error: SMFService constructor called but SMF is not available.");
        }
        this.init_old_delete_me();
    }

    static boolean apropos() {
        return OS.isSun() && new File(SVCADM).isFile();
    }

    @Override
    public void createServiceInternal() {
        boolean previousManifestExists = new File(this.getManifestFilePath()).exists();
        try {
            this.isConfigValid();
            if (this.info.trace) {
                this.printOut(this.toString());
            }
            this.validateManifest(this.getManifestFilePath());
            previousManifestExists = false;
            ServicesUtils.tokenReplaceTemplateAtDestination(this.tokensAndValues(), this.getManifestFileTemplatePath(), this.getManifestFilePath());
            this.validateService();
            this.importService();
        }
        catch (Exception e) {
            if (!previousManifestExists) {
                this.cleanupManifest();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteServiceInternal() {
        try {
            StringBuilder sb;
            String serviceName = this.info.serviceName;
            if (!SMFService.ok(serviceName)) {
                throw new RuntimeException(Strings.get("internal.error", "no service name is set"));
            }
            String me = System.getProperty("user.name");
            if (!this.isUserSmfAuthorized(me, sb = new StringBuilder())) {
                throw new RuntimeException(Strings.get("noSmfAuth", me, sb.toString()));
            }
            ProcessManager pm = new ProcessManager(SVCADM, "disable", this.info.serviceName);
            pm.setEcho(false);
            pm.execute();
            pm = new ProcessManager(SVCCFG, "delete", this.info.serviceName);
            pm.setEcho(false);
            pm.execute();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void checkServiceName() {
        if (this.serviceNameExists(this.info.smfFullServiceName)) {
            String msg = sm.getString("serviceNameExists", this.info.smfFullServiceName);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public int getTimeoutSeconds() {
        int to = Integer.parseInt(this.getTokenMap().get("TIMEOUT_SECONDS"));
        return to;
    }

    @Override
    public void setTimeoutSeconds(int number) {
        Integer to = number;
        if (to < 0) {
            String msg = sm.getString("invalidTO", number);
            throw new IllegalArgumentException(msg);
        }
        this.getTokenMap().put("TIMEOUT_SECONDS", to.toString());
    }

    private void checkOSUser() {
        if (!this.canCreateManifest()) {
            String msg = sm.getString("noPermissionToCreateManifest", this.info.osUser, MANIFEST_HOME);
            throw new IllegalArgumentException(msg);
        }
        StringBuilder auths = new StringBuilder();
        if (!this.isUserSmfAuthorized(this.info.osUser, auths)) {
            String msg = sm.getString("noSmfAuth", this.info.osUser, auths);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public String getServiceProperties() {
        return this.getTokenMap().get("PRIVILEGES");
    }

    @Override
    public void setServiceProperties(String cds) {
        if (cds != null) {
            Set<String> props = this.ps2Pairs(cds);
            if (props.contains(NETADDR_PRIV_VAL)) {
                this.getTokenMap().put("PRIVILEGES", BASIC_NETADDR_PRIV_VAL);
            }
            if (props.contains(NO_START_INSTANCES_PROPERTY)) {
                this.getTokenMap().put(START_INSTANCES_TN, Boolean.FALSE.toString());
            }
        }
    }

    @Override
    public boolean isConfigValid() {
        Set<String> keys = this.getTokenMap().keySet();
        for (String k : keys) {
            boolean aNullValue = NULL_VALUE.equals(this.getTokenMap().get(k));
            if (!aNullValue) continue;
            String msg = sm.getString("smfTokenNeeded", k, this.getTokenMap().get(k));
            throw new RuntimeException(msg);
        }
        File mf = new File(this.getManifestFileTemplatePath());
        if (!mf.exists()) {
            String msg = sm.getString("serviceTemplateNotFound", this.getManifestFileTemplatePath());
            throw new RuntimeException(msg);
        }
        return true;
    }

    @Override
    public Map<String, String> tokensAndValues() {
        return new HashMap<String, String>(this.getTokenMap());
    }

    @Override
    public String getManifestFilePath() {
        String fn = MANIFEST_HOME + this.info.fqsn + "/" + MANIFEST_FILE_SUFFIX;
        return fn;
    }

    @Override
    public String getManifestFileTemplatePath() {
        String ir = System.getProperty("com.sun.aas.installRoot");
        if (!SMFService.ok(ir)) {
            throw new RuntimeException("Internal Error - System Property not set: com.sun.aas.installRoot");
        }
        File rootDir = SmartFile.sanitize(new File(ir));
        if (!rootDir.isDirectory()) {
            throw new RuntimeException("Internal Error - Not a directory: " + rootDir);
        }
        File templatesDir = new File(rootDir, REL_PATH_TEMPLATES);
        String filename = MANIFEST_FILE_TEMPL_SUFFIX;
        File f = new File(templatesDir, filename);
        return f.getPath();
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String[] ka = new String[this.getTokenMap().size()];
        Arrays.sort(this.getTokenMap().keySet().toArray(ka));
        for (String n : ka) {
            sb.append(n).append("=").append(this.getTokenMap().get(n)).append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    @Override
    public String getSuccessMessage() {
        String msg = Strings.get("SMFServiceCreated", this.info.smfFullServiceName, this.info.type.toString(), this.info.serverDirs.getServerParentDir(), this.getManifestFilePath(), this.info.serviceName);
        if (this.info.dryRun) {
            msg = msg + Strings.get("dryrun");
        }
        return msg;
    }

    @Override
    public void initializeInternal() {
        this.checkOSUser();
        this.checkServiceName();
    }

    private void init_old_delete_me() {
        this.getTokenMap().put(START_INSTANCES_TN, START_INSTANCES_DEFAULT_VAL);
        this.getTokenMap().put("AS_ADMIN_USER", AS_ADMIN_USER_DEF_VAL);
        this.getTokenMap().put("TIMEOUT_SECONDS", TIMEOUT_SECONDS_DV);
        this.getTokenMap().put("PRIVILEGES", BASIC_NETADDR_PRIV_VAL);
        this.getTokenMap().put("CREDENTIALS", " ");
    }

    private Set<String> ps2Pairs(String cds) {
        StringTokenizer p = new StringTokenizer(cds, SP_DELIMITER);
        HashSet<String> tokens = new HashSet<String>();
        while (p.hasMoreTokens()) {
            tokens.add(p.nextToken());
        }
        return tokens;
    }

    private boolean canCreateManifest() {
        File mh = new File(MANIFEST_HOME);
        boolean ok = true;
        if (!mh.exists()) {
            ok = mh.mkdirs();
        }
        if (ok && !mh.canWrite()) {
            ok = false;
        }
        return ok;
    }

    private boolean isUserSmfAuthorized(String user, StringBuilder auths) {
        boolean authorized = false;
        String path2Auths = "auths";
        String at = ",";
        String AUTH1 = "solaris.*";
        String AUTH2 = "solaris.smf.*";
        String AUTH3 = "solaris.smf.modify";
        if (System.getProperty("PATH_2_AUTHS") != null) {
            path2Auths = System.getProperty("PATH_2_AUTHS");
        }
        if (System.getProperty("AUTH_TOKEN") != null) {
            at = System.getProperty("AUTH_TOKEN");
        }
        try {
            String[] cmd = new String[]{path2Auths, user};
            ProcessExecutor pe = new ProcessExecutor(cmd);
            pe.setExecutionRetentionFlag(true);
            pe.execute();
            auths.append(pe.getLastExecutionOutput());
            StringTokenizer st = new StringTokenizer(pe.getLastExecutionOutput(), at);
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (!"solaris.*".equals(t = t.trim()) && !"solaris.smf.*".equals(t) && !"solaris.smf.modify".equals(t)) continue;
                authorized = true;
                break;
            }
            return authorized;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean serviceNameExists(String sn) {
        boolean exists = false;
        try {
            String[] cmd = new String[]{"/usr/bin/svcs", sn};
            ProcessExecutor pe = new ProcessExecutor(cmd);
            pe.setExecutionRetentionFlag(true);
            pe.execute();
            exists = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    private void validateManifest(String manifestPath) throws Exception {
        File manifest = new File(manifestPath);
        File manifestParent = manifest.getParentFile();
        String msg = sm.getString("smfLeftoverFiles", manifest.getParentFile().getAbsolutePath());
        if (manifestParent != null && manifestParent.isDirectory()) {
            if (this.info.force) {
                FileUtils.whack(manifestParent);
                if (manifestParent.isDirectory()) {
                    throw new IllegalArgumentException(msg);
                }
            } else {
                throw new IllegalArgumentException(msg);
            }
        }
        if (!manifest.getParentFile().mkdirs() && this.info.trace) {
            this.printOut("Failed to create manifest parent file: " + manifest.getParentFile().getAbsolutePath());
        }
        if (this.info.trace) {
            this.printOut("Manifest validated: " + manifestPath);
        }
    }

    private void validateService() throws Exception {
        String[] cmda = new String[]{SVCCFG, "validate", this.getManifestFilePath()};
        ProcessExecutor pe = new ProcessExecutor(cmda);
        pe.execute();
        if (this.info.trace) {
            this.printOut("Validated the SMF Service: " + this.info.fqsn + " using: " + SVCCFG);
        }
    }

    private boolean importService() throws Exception {
        String[] cmda = new String[]{SVCCFG, "import", this.getManifestFilePath()};
        ProcessExecutor pe = new ProcessExecutor(cmda);
        if (this.info.dryRun) {
            this.cleanupManifest();
        } else {
            pe.execute();
        }
        if (this.info.trace) {
            this.printOut("Imported the SMF Service: " + this.info.fqsn);
        }
        return true;
    }

    private void cleanupManifest() throws RuntimeException {
        File failedServiceNode;
        File manifest = new File(this.getManifestFilePath());
        if (manifest.exists()) {
            if (!manifest.delete()) {
                manifest.deleteOnExit();
            }
            if (this.info.trace) {
                this.printOut("Attempted deleting failed service manifest: " + manifest.getAbsolutePath());
            }
        }
        if ((failedServiceNode = manifest.getParentFile()).exists()) {
            if (!failedServiceNode.delete()) {
                failedServiceNode.deleteOnExit();
            }
            if (this.info.trace) {
                this.printOut("Attempted deleting failed service folder: " + failedServiceNode.getAbsolutePath());
            }
        }
    }

    private void printOut(String s) {
        System.out.println(s);
    }

    @Override
    public void writeReadmeFile(String msg) {
        File f = new File(this.getServerDirs().getServerDir(), "PlatformServices.log");
        ServicesUtils.appendTextToFile(f, msg);
    }

    @Override
    public final String getLocationArgsStart() {
        if (this.isDomain()) {
            return " --domaindir " + this.getServerDirs().getServerParentDir().getPath() + " ";
        }
        return " --nodedir " + this.getServerDirs().getServerGrandParentDir().getPath() + " --node " + this.getServerDirs().getServerParentDir().getName() + " ";
    }

    @Override
    public final String getLocationArgsStop() {
        return this.getLocationArgsStart();
    }
}

