/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.backup.BackupRestoreManager;
import com.sun.enterprise.backup.BackupWarningException;
import com.sun.enterprise.backup.DirectoryFilter;
import com.sun.enterprise.backup.Status;
import com.sun.enterprise.backup.ZipFilenameFilter;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.ColumnFormatter;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;

public class ListManager
extends BackupRestoreManager {
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListManager.class);
    File[] zips;
    private static final String BACKUP = "CONFIG";
    private static final String USER = "USER";
    private static final String DATE = "BACKUP-DATE";
    private static final String FILENAME = "FILENAME";

    public ListManager(BackupRequest req) throws BackupException, BackupWarningException {
        super(req);
    }

    public String list() throws BackupException {
        StringBuffer sb = new StringBuffer();
        String[] headings = new String[]{BACKUP, USER, DATE, FILENAME};
        ArrayList<Integer> badPropsList = null;
        ColumnFormatter cf = null;
        boolean itemInRow = false;
        TreeSet<Status> statusSet = new TreeSet<Status>(new FileNameComparator());
        this.findZips(this.request.backupConfig == null);
        badPropsList = new ArrayList<Integer>();
        for (int i = 0; i < this.zips.length; ++i) {
            Status status = new Status();
            if (!status.loadProps(this.zips[i])) {
                badPropsList.add(i);
                continue;
            }
            statusSet.add(status);
            itemInRow = true;
        }
        if (itemInRow) {
            for (Status status : statusSet) {
                if (this.request.verbose) {
                    File f = null;
                    try {
                        f = new File(status.getBackupPath());
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (f == null) continue;
                    sb.append(status.read(f, this.request.terse));
                    sb.append("\n\n");
                    continue;
                }
                String filename = status.getFileName();
                if (cf == null) {
                    cf = new ColumnFormatter(headings);
                }
                if (filename == null) {
                    filename = strings.get("backup-list.unavailable");
                }
                cf.addRow(new Object[]{status.getBackupConfigName(), status.getUserName(), status.getTimeStamp(), filename});
            }
        }
        if (cf != null) {
            sb.append(cf.toString());
        }
        if (!itemInRow && !this.request.terse) {
            sb.append("\n" + strings.get("backup-list.nothing"));
        }
        if (badPropsList != null && !badPropsList.isEmpty()) {
            sb.append("\n\n");
            sb.append(strings.get("backup-list.bad-props"));
            for (Integer iInt : badPropsList) {
                sb.append("\n");
                sb.append(this.zips[iInt]);
            }
        }
        return sb.toString();
    }

    @Override
    void init() throws BackupException, BackupWarningException {
        super.init();
        if (!FileUtils.safeIsDirectory(this.request.domainDir)) {
            throw new BackupException("backup-res.NoDomainDir", this.request.domainDir);
        }
        if (!FileUtils.safeIsDirectory(this.getBackupDirectory(this.request))) {
            throw new BackupWarningException("backup-res.NoBackupDir", this.getBackupDirectory(this.request));
        }
    }

    private void findZips(boolean subdirs) throws BackupWarningException {
        ArrayList<File> zipList = new ArrayList<File>();
        File[] files = this.getBackupDirectory(this.request).listFiles(new ZipFilenameFilter());
        if (subdirs) {
            int i;
            for (i = 0; files != null && i < files.length; ++i) {
                zipList.add(files[i]);
            }
            File[] dirs = this.getBackupDirectory(this.request).listFiles(new DirectoryFilter());
            for (i = 0; dirs != null && i < dirs.length; ++i) {
                files = dirs[i].listFiles(new ZipFilenameFilter());
                for (int j = 0; files != null && j < files.length; ++j) {
                    zipList.add(files[j]);
                }
            }
            if (zipList.size() > 0) {
                this.zips = zipList.toArray(new File[zipList.size()]);
            }
        } else {
            this.zips = files;
        }
        if (this.zips == null || this.zips.length <= 0) {
            throw new BackupWarningException("backup-res.NoBackupFiles", this.getBackupDirectory(this.request));
        }
    }

    private static class FileNameComparator
    implements Comparator<Status>,
    Serializable {
        private FileNameComparator() {
        }

        @Override
        public int compare(Status s1, Status s2) {
            if (s1.getBackupConfigName().equals(s2.getBackupConfigName())) {
                return this.compareFiles(s1.getFileName(), s2.getFileName());
            }
            return s1.getBackupConfigName().compareTo(s2.getBackupConfigName());
        }

        private int compareFiles(String f1, String f2) {
            int f2Num;
            int f1Num;
            if (f1 == null) {
                f1 = strings.get("backup-list.unavailable");
            }
            if (f2 == null) {
                f2 = strings.get("backup-list.unavailable");
            }
            f1 = f1.substring(f1.lastIndexOf("_v") + 2, f1.length() - 4);
            try {
                f1Num = Integer.parseInt(f1);
            }
            catch (Exception e) {
                f1Num = -1;
            }
            f2 = f2.substring(f2.lastIndexOf("_v") + 2, f2.length() - 4);
            try {
                f2Num = Integer.parseInt(f2);
            }
            catch (Exception e) {
                f2Num = -1;
            }
            return f1Num - f2Num;
        }
    }
}

