/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeExtension;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.connectors.config.WorkSecurityMap;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.RelativePathResolver;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resources.api.ResourcesRegistry;
import org.jvnet.hk2.config.ConfigBeanProxy;

public class ResourcesUtil {
    static Logger _logger = LogDomains.getLogger(ResourcesUtil.class, "javax.enterprise.resource.resourceadapter");
    static StringManager localStrings = StringManager.getManager(ResourcesUtil.class);
    static ServerContext sc_ = null;
    protected Domain domain = null;
    protected Resources resources = null;
    private ConnectorRuntime runtime;
    private Server server;
    private static volatile ResourcesUtil resourcesUtil;

    private ResourcesUtil() {
    }

    public Resources getGlobalResources() {
        return this.getRuntime().getResources();
    }

    public Resources getResources(ResourceInfo resourceInfo) {
        return this.getRuntime().getResources(resourceInfo);
    }

    public Resources getResources(PoolInfo poolInfo) {
        return this.getRuntime().getResources(poolInfo);
    }

    private Domain getDomain() {
        if (this.domain == null) {
            this.domain = this.getRuntime().getDomain();
        }
        return this.domain;
    }

    private ConnectorRuntime getRuntime() {
        if (this.runtime == null) {
            this.runtime = ConnectorRuntime.getRuntime();
        }
        return this.runtime;
    }

    private Server getServer() {
        if (this.server == null) {
            this.server = this.getDomain().getServerNamed(this.getRuntime().getServerEnvironment().getInstanceName());
        }
        return this.server;
    }

    private Applications getApplications() {
        return this.getRuntime().getApplications();
    }

    private com.sun.enterprise.config.serverbeans.Application getApplicationByName(String name) {
        com.sun.enterprise.config.serverbeans.Application application = null;
        List<com.sun.enterprise.config.serverbeans.Application> apps = this.getApplications().getApplications();
        for (com.sun.enterprise.config.serverbeans.Application app : apps) {
            if (!app.getName().equals(name)) continue;
            application = app;
            break;
        }
        return application;
    }

    public String getApplicationDeployLocation(String appName) {
        String location = null;
        com.sun.enterprise.config.serverbeans.Application app = this.getApplicationByName(appName);
        if (app != null) {
            location = RelativePathResolver.resolvePath(app.getLocation());
        }
        return location;
    }

    public boolean belongToStandAloneRar(String resourceAdapterName) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourcesUtil createInstance() {
        if (resourcesUtil != null) return resourcesUtil;
        Class<ResourcesUtil> clazz = ResourcesUtil.class;
        synchronized (ResourcesUtil.class) {
            if (resourcesUtil != null) return resourcesUtil;
            resourcesUtil = new ResourcesUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return resourcesUtil;
        }
    }

    public DeferredResourceConfig getDeferredResourceConfig(Object resource, Object pool, String resType, String raName) throws ConnectorRuntimeException {
        DeferredResourceConfig resConfig = null;
        if (resource instanceof ConnectorResource || pool instanceof ConnectorConnectionPool) {
            ConnectorConnectionPool connPool = (ConnectorConnectionPool)pool;
            ConnectorResource connResource = (ConnectorResource)resource;
            String resourceAdapterName = connPool.getResourceAdapterName();
            resConfig = new DeferredResourceConfig(resourceAdapterName, null, connPool, connResource, null);
            Resource[] resourcesToload = new Resource[]{connPool, connResource};
            resConfig.setResourcesToLoad(resourcesToload);
        } else {
            List<ConnectorRuntimeExtension> extensions = Globals.getDefaultHabitat().getAllServices(ConnectorRuntimeExtension.class, new Annotation[0]);
            Iterator iterator = extensions.iterator();
            if (iterator.hasNext()) {
                ConnectorRuntimeExtension extension = (ConnectorRuntimeExtension)iterator.next();
                return extension.getDeferredResourceConfig(resource, pool, resType, raName);
            }
        }
        return resConfig;
    }

    protected String getCorrespondingCmpResourceName(ResourceInfo resourceInfo) {
        int index = resourceInfo.getName().lastIndexOf("__pm");
        if (index != -1) {
            return resourceInfo.getName().substring(0, index);
        }
        return null;
    }

    public boolean isReferenced(ResourceInfo resourceInfo) {
        boolean refExists = false;
        if (ConnectorsUtil.isModuleScopedResource(resourceInfo) || ConnectorsUtil.isApplicationScopedResource(resourceInfo)) {
            refExists = this.getServer().getApplicationRef(resourceInfo.getApplicationName()) != null;
        } else {
            String resourceName = resourceInfo.getName();
            refExists = this.getServer().isResourceRefExists(resourceName);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("isReferenced :: " + resourceInfo + " - " + refExists);
        }
        return refExists;
    }

    public boolean isEnabled(com.sun.enterprise.config.serverbeans.Application application) {
        if (application == null) {
            return false;
        }
        boolean appEnabled = Boolean.valueOf(application.getEnabled());
        ApplicationRef appRef = this.getServer().getApplicationRef(application.getName());
        boolean appRefEnabled = false;
        if (appRef != null) {
            appRefEnabled = Boolean.valueOf(appRef.getEnabled());
        }
        return appEnabled && appRefEnabled;
    }

    public boolean isEnabled(Resource resource) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: isEnabled");
        }
        if (resource == null) {
            return false;
        }
        if (resource instanceof BindableResource) {
            BindableResource bindableResource = (BindableResource)resource;
            if (bindableResource.getJndiName().contains("__datasource_definition/")) {
                return Boolean.valueOf(bindableResource.getEnabled());
            }
            ResourceRef resRef = this.getServer().getResourceRef(((BindableResource)resource).getJndiName());
            return this.isEnabled((BindableResource)resource) && resRef != null && this.parseBoolean(resRef.getEnabled());
        }
        if (resource instanceof ResourcePool) {
            return this.isEnabled((ResourcePool)resource);
        }
        return resource instanceof WorkSecurityMap || resource instanceof ResourceAdapterConfig;
    }

    public boolean isEnabled(ResourcePool pool) {
        boolean enabled = true;
        if (pool == null) {
            return false;
        }
        if (pool instanceof ConnectorConnectionPool) {
            ConnectorConnectionPool ccpool = (ConnectorConnectionPool)pool;
            String raName = ccpool.getResourceAdapterName();
            enabled = this.isRarEnabled(raName);
        }
        return enabled;
    }

    public boolean isEnabled(BindableResource br, ResourceInfo resourceInfo) {
        boolean enabled = false;
        if (br == null) {
            return false;
        }
        boolean resourceEnabled = ConnectorsUtil.parseBoolean(br.getEnabled());
        if (resourceInfo.getName().contains("__datasource_definition/")) {
            return resourceEnabled;
        }
        boolean refEnabled = this.isResourceReferenceEnabled(resourceInfo);
        if (br instanceof ConnectorResource) {
            ConnectorResource cr = (ConnectorResource)br;
            String poolName = cr.getPoolName();
            ConnectorConnectionPool ccp = (ConnectorConnectionPool)ConnectorsUtil.getResourceByName(this.getResources(resourceInfo), ConnectorConnectionPool.class, poolName);
            if (ccp == null) {
                return false;
            }
            boolean poolEnabled = this.isEnabled(ccp);
            enabled = poolEnabled && resourceEnabled && refEnabled;
        } else if (br instanceof AdminObjectResource) {
            if (resourceEnabled && refEnabled) {
                enabled = true;
            }
        } else if (refEnabled && resourceEnabled) {
            enabled = true;
        }
        return enabled;
    }

    public boolean isEnabled(BindableResource br) {
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(br);
        return this.isEnabled(br, resourceInfo);
    }

    private boolean isRarEnabled(String raName) {
        if (raName == null || raName.length() == 0) {
            return false;
        }
        com.sun.enterprise.config.serverbeans.Application application = this.getDomain().getApplications().getApplication(raName);
        if (application != null) {
            return this.isApplicationReferenceEnabled(raName);
        }
        if (ConnectorsUtil.belongsToSystemRA(raName)) {
            return true;
        }
        return this.belongToEmbeddedRarAndEnabled(raName);
    }

    private boolean isApplicationReferenceEnabled(String appName) {
        ApplicationRef appRef = this.getServer().getApplicationRef(appName);
        if (appRef == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ResourcesUtil :: isApplicationReferenceEnabled null ref");
            }
            return false;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: isApplicationReferenceEnabled appRef enabled ?" + appRef.getEnabled());
        }
        return ConnectorsUtil.parseBoolean(appRef.getEnabled());
    }

    public Collection<AdminObjectResource> getEnabledAdminObjectResources(String raName) {
        ArrayList<AdminObjectResource> allResources = new ArrayList<AdminObjectResource>();
        allResources.addAll(this.getEnabledAdminObjectResources(raName, this.getGlobalResources()));
        return allResources;
    }

    public Collection<AdminObjectResource> getEnabledAdminObjectResources(String raName, Resources resources) {
        ArrayList<AdminObjectResource> adminObjectResources = new ArrayList<AdminObjectResource>();
        for (Resource resource : resources.getResources(AdminObjectResource.class)) {
            AdminObjectResource adminObjectResource = (AdminObjectResource)resource;
            String resourceAdapterName = adminObjectResource.getResAdapter();
            if (resourceAdapterName == null || raName != null && !raName.equals(resourceAdapterName) || !this.isEnabled(adminObjectResource)) continue;
            adminObjectResources.add(adminObjectResource);
        }
        return adminObjectResources;
    }

    private boolean belongToEmbeddedRarAndEnabled(String resourceAdapterName) {
        String appName = this.getAppNameToken(resourceAdapterName);
        if (appName == null) {
            return false;
        }
        Applications apps = this.getDomain().getApplications();
        com.sun.enterprise.config.serverbeans.Application app = apps.getApplication(appName);
        if (app == null || !ConnectorsUtil.parseBoolean(app.getEnabled())) {
            return false;
        }
        return this.isApplicationReferenceEnabled(appName);
    }

    private String getAppNameToken(String rarName) {
        if (rarName == null) {
            return null;
        }
        int index = rarName.indexOf("#");
        if (index != -1) {
            return rarName.substring(0, index);
        }
        return null;
    }

    private boolean isResourceReferenceEnabled(ResourceInfo resourceInfo) {
        String enabled = "false";
        if (ConnectorsUtil.isModuleScopedResource(resourceInfo) || ConnectorsUtil.isApplicationScopedResource(resourceInfo)) {
            ApplicationRef appRef = this.getServer().getApplicationRef(resourceInfo.getApplicationName());
            if (appRef != null) {
                enabled = appRef.getEnabled();
            } else {
                enabled = "true";
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("ResourcesUtil :: isResourceReferenceEnabled null app-ref");
                }
            }
        } else {
            ResourceRef ref = this.getServer().getResourceRef(resourceInfo.getName());
            if (ref != null) {
                enabled = ref.getEnabled();
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ResourcesUtil :: isResourceReferenceEnabled null ref");
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ResourcesUtil :: isResourceReferenceEnabled ref enabled ?" + enabled);
        }
        return ConnectorsUtil.parseBoolean(enabled);
    }

    public String getResourceType(ConfigBeanProxy cb) {
        if (cb instanceof ConnectorConnectionPool) {
            return "ccp";
        }
        if (cb instanceof ConnectorResource) {
            return "cr";
        }
        List<ConnectorRuntimeExtension> extensions = Globals.getDefaultHabitat().getAllServices(ConnectorRuntimeExtension.class, new Annotation[0]);
        Iterator iterator = extensions.iterator();
        if (iterator.hasNext()) {
            ConnectorRuntimeExtension extension = (ConnectorRuntimeExtension)iterator.next();
            return extension.getResourceType(cb);
        }
        return null;
    }

    private boolean parseBoolean(String enabled) {
        return Boolean.parseBoolean(enabled);
    }

    public ConnectorDescriptor getConnectorDescriptorFromUri(String rarName, String raLoc) {
        try {
            String appName = rarName.substring(0, rarName.indexOf("#"));
            String appDeployLocation = ResourcesUtil.createInstance().getApplicationDeployLocation(appName);
            FileArchive in = ConnectorRuntime.getRuntime().getFileArchive();
            in.open(new URI(appDeployLocation));
            ApplicationArchivist archivist = ConnectorRuntime.getRuntime().getApplicationArchivist();
            Application application = archivist.open(in);
            return application.getModuleByTypeAndUri(ConnectorDescriptor.class, raLoc);
        }
        catch (Exception e) {
            Object[] params = new Object[]{rarName, e};
            _logger.log(Level.WARNING, "error.getting.connector.descriptor", params);
            return null;
        }
    }

    public boolean isPoolReferredInServerInstance(PoolInfo poolInfo) {
        Collection<ConnectorResource> connectorResources = this.getRuntime().getResources(poolInfo).getResources(ConnectorResource.class);
        for (ConnectorResource resource : connectorResources) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("poolname " + resource.getPoolName() + "resource " + resource.getJndiName());
            }
            ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(resource);
            if (!resource.getPoolName().equalsIgnoreCase(poolInfo.getName()) || !this.isReferenced(resourceInfo) || !this.isEnabled(resource)) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Connector resource " + resource.getJndiName() + "refers " + poolInfo + "in this server instance and is enabled");
            }
            return true;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("No Connector resource refers [ " + poolInfo + " ] in this server instance");
        }
        return false;
    }

    public ResourcePool getPoolConfig(PoolInfo poolInfo) {
        Resources resources = this.getResources(poolInfo);
        ResourcePool pool = null;
        if (resources != null) {
            pool = (ResourcePool)ConnectorsUtil.getResourceByName(resources, ResourcePool.class, poolInfo.getName());
        }
        return pool;
    }

    public ConnectorConnectionPool getConnectorConnectionPoolOfResource(ResourceInfo resourceInfo) {
        ConnectorResource resource = null;
        ConnectorConnectionPool pool = null;
        Resources resources = this.getResources(resourceInfo);
        if (resources != null && (resource = (ConnectorResource)ConnectorsUtil.getResourceByName(resources, ConnectorResource.class, resourceInfo.getName())) != null) {
            pool = (ConnectorConnectionPool)ConnectorsUtil.getResourceByName(resources, ConnectorConnectionPool.class, resource.getPoolName());
        }
        return pool;
    }

    public boolean isRARResource(Resource resource) {
        return ConnectorsUtil.isRARResource(resource);
    }

    public String getRarNameOfResource(Resource resource, Resources resources) {
        return ConnectorsUtil.getRarNameOfResource(resource, resources);
    }

    public Resource getResource(ResourceInfo resourceInfo, Class resourceType) {
        Resource resource = null;
        String appName = resourceInfo.getApplicationName();
        String jndiName = resourceInfo.getName();
        String moduleName = resourceInfo.getModuleName();
        Resources resources = null;
        if (ConnectorsUtil.isApplicationScopedResource(resourceInfo) || ConnectorsUtil.isModuleScopedResource(resourceInfo)) {
            if (this.getApplicationByName(appName) != null) {
                resources = this.getResources(resourceInfo);
            }
        } else {
            resources = this.getResources(resourceInfo);
        }
        if (resources != null) {
            resource = ConnectorsUtil.getResourceByName(resources, resourceType, jndiName);
        } else if (ConnectorsUtil.isApplicationScopedResource(resourceInfo) || ConnectorsUtil.isModuleScopedResource(resourceInfo)) {
            if (ConnectorsUtil.isApplicationScopedResource(resourceInfo)) {
                moduleName = appName;
            }
            if ((resources = ResourcesRegistry.getResources(appName, moduleName)) != null) {
                resource = ConnectorsUtil.getResourceByName(resources, resourceType, jndiName);
            }
        }
        return resource;
    }

    public Resource getResource(String jndiName, String appName, String moduleName, Class resourceType) {
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, appName, moduleName);
        return this.getResource(resourceInfo, resourceType);
    }

    public Collection<Resource> filterConnectorResources(Resources allResources, String moduleName, boolean includePools) {
        Collection<ConnectorConnectionPool> connectionPools = ConnectorsUtil.getAllPoolsOfModule(moduleName, allResources);
        Collection<String> poolNames = ConnectorsUtil.getAllPoolNames(connectionPools);
        Collection<Resource> resources = ConnectorsUtil.getAllResources(poolNames, allResources);
        Collection<AdminObjectResource> adminObjectResources = ResourcesUtil.createInstance().getEnabledAdminObjectResources(moduleName);
        resources.addAll(adminObjectResources);
        if (includePools) {
            Collection<ConnectorConnectionPool> allPoolsOfModule = ConnectorsUtil.getAllPoolsOfModule(moduleName, allResources);
            resources.addAll(allPoolsOfModule);
        }
        return resources;
    }
}

