/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.EjbsContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentsContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;

public abstract class AbstractResourceHandler
extends AbstractHandler {
    protected abstract HandlerProcessingResult processAnnotation(AnnotationInfo var1, ResourceContainerContext[] var2) throws AnnotationProcessorException;

    @Override
    public HandlerProcessingResult processAnnotation(AnnotationInfo ainfo) throws AnnotationProcessorException {
        AnnotatedElementHandler aeHandler = ainfo.getProcessingContext().getHandler();
        if (aeHandler instanceof EjbBundleContext) {
            EjbBundleContext ejbBundleContext = (EjbBundleContext)aeHandler;
            if ((aeHandler = ejbBundleContext.createContextForEjb()) == null) {
                aeHandler = ejbBundleContext.createContextForEjbInterceptor();
            }
            EjbBundleDescriptor bundleDesc = ejbBundleContext.getDescriptor();
            Object enclosingBundle = bundleDesc.getModuleDescriptor().getDescriptor();
            boolean ejbJar = enclosingBundle instanceof EjbBundleDescriptor;
            if (aeHandler == null && ejbJar) {
                aeHandler = ejbBundleContext;
            }
        }
        if (aeHandler == null) {
            return this.getInvalidAnnotatedElementHandlerResult(ainfo.getProcessingContext().getHandler(), ainfo);
        }
        ResourceContainerContext[] rcContexts = null;
        if (aeHandler instanceof EjbsContext) {
            EjbsContext ejbsContext = (EjbsContext)aeHandler;
            rcContexts = ejbsContext.getEjbContexts();
        } else if (aeHandler instanceof WebComponentsContext) {
            WebComponentsContext webCompsContext = (WebComponentsContext)aeHandler;
            rcContexts = webCompsContext.getWebComponentContexts();
        } else if (aeHandler instanceof ResourceContainerContext) {
            rcContexts = new ResourceContainerContext[]{(ResourceContainerContext)((Object)aeHandler)};
        } else {
            return this.getInvalidAnnotatedElementHandlerResult(aeHandler, ainfo);
        }
        return this.processAnnotation(ainfo, rcContexts);
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }

    protected boolean isAEjbComponentClass(Annotation[] annotations) {
        Class<? extends Annotation>[] ejbAnnotations = this.getEjbAnnotationTypes();
        for (Annotation annotation : annotations) {
            for (Class<? extends Annotation> ejbAnnotation : ejbAnnotations) {
                if (!ejbAnnotation.equals(annotation.annotationType())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAWebComponentClass(Annotation[] annotations) {
        Class<? extends Annotation>[] webAnnotations = this.getWebAnnotationTypes();
        for (Annotation annotation : annotations) {
            for (Class<? extends Annotation> webAnnotation : webAnnotations) {
                if (!webAnnotation.equals(annotation.annotationType())) continue;
                return true;
            }
        }
        return false;
    }

    protected void validateAnnotatedLifecycleMethod(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw new IllegalArgumentException(localStrings.getLocalString("lifecycle_method_invalid_param_size", "The lifecycle method [{0}] must not have more than one parameter", method.getName()));
        }
        if (parameterTypes.length == 0) {
            Class<?>[] exceptionTypes;
            for (Class<?> exception : exceptionTypes = method.getExceptionTypes()) {
                if (RuntimeException.class.isAssignableFrom(exception)) continue;
                throw new IllegalArgumentException(localStrings.getLocalString("lifecycle_method_no_checked_exception", "The lifecycle method [{0}] must not throw a checked exception", method.getName()));
            }
            Class<?> returnType = method.getReturnType();
            if (!returnType.equals(Void.TYPE)) {
                throw new IllegalArgumentException(localStrings.getLocalString("lifecycle_method_return_type_void", "The return type of the lifecycle method [{0}] must be void", method.getName()));
            }
        }
    }
}

