/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivist;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ArchivistFactory {
    public static final String ARCHIVE_TYPE = "archiveType";
    public static final String EXTENSION_ARCHIVE_TYPE = "extensionArchiveType";
    @Inject
    private ServiceLocator habitat;

    public Archivist getArchivist(String archiveType, ClassLoader cl) {
        Archivist result = this.getArchivist(archiveType);
        if (result != null) {
            result.setClassLoader(cl);
        }
        return result;
    }

    public Archivist getArchivist(String archiveType) {
        ActiveDescriptor<?> best = this.habitat.getBestDescriptor(new ArchivistFilter(archiveType, ARCHIVE_TYPE, Archivist.class));
        if (best == null) {
            return null;
        }
        return (Archivist)this.habitat.getServiceHandle(best).getService();
    }

    public Archivist getArchivist(ArchiveType moduleType) {
        return this.getArchivist(String.valueOf(moduleType));
    }

    public List<ExtensionsArchivist> getExtensionsArchivists(Collection<Sniffer> sniffers, ArchiveType moduleType) {
        HashSet<String> containerTypes = new HashSet<String>();
        for (Sniffer sniffer : sniffers) {
            containerTypes.add(sniffer.getModuleType());
        }
        ArrayList<ExtensionsArchivist> archivists = new ArrayList<ExtensionsArchivist>();
        for (String containerType : containerTypes) {
            List<ActiveDescriptor<?>> descriptors = this.habitat.getDescriptors(new ArchivistFilter(containerType, EXTENSION_ARCHIVE_TYPE, ExtensionsArchivist.class));
            for (ActiveDescriptor<?> item : descriptors) {
                ActiveDescriptor<?> descriptor = item;
                ServiceHandle<?> handle = this.habitat.getServiceHandle(descriptor);
                ExtensionsArchivist ea = (ExtensionsArchivist)handle.getService();
                if (!ea.supportsModuleType(moduleType)) continue;
                archivists.add(ea);
            }
        }
        return archivists;
    }

    private static class ArchivistFilter
    implements IndexedFilter {
        private final String archiveType;
        private final String metadataKey;
        private final Class<?> index;

        private ArchivistFilter(String archiveType, String metadataKey, Class<?> index) {
            this.archiveType = archiveType;
            this.metadataKey = metadataKey;
            this.index = index;
        }

        @Override
        public boolean matches(Descriptor d) {
            Map<String, List<String>> metadata = d.getMetadata();
            List<String> values = metadata.get(this.metadataKey);
            if (values == null) {
                return false;
            }
            return values.contains(this.archiveType);
        }

        @Override
        public String getAdvertisedContract() {
            return this.index.getName();
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

