/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.common.MessageSecurityBindingNode;
import com.sun.enterprise.deployment.node.runtime.common.RuntimeNameValuePairNode;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebServiceEndpointRuntimeNode
extends DeploymentDescriptorNode {
    private static final Logger logger = DOLUtils.getDefaultLogger();
    @LogMessageInfo(message="Unknown port-component-name {0} port, all sub elements will be ignored.", level="SEVERE", cause="Used port-component-name does not exists.", action="Use the name of existing web service endpoint")
    private static final String WS_PORT_UNKNOWN = "AS-DEPLOYMENT-00016";
    private Descriptor descriptor;

    public WebServiceEndpointRuntimeNode() {
        this.registerElementHandler(new XMLElement("message-security-binding"), MessageSecurityBindingNode.class, "setMessageSecurityBinding");
        this.registerElementHandler(new XMLElement("property"), RuntimeNameValuePairNode.class, "addProperty");
    }

    @Override
    public Object getDescriptor() {
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("endpoint-address-uri", "setEndpointAddressUri");
        table.put("tie-class", "setTieClassName");
        table.put("servlet-impl-class", "setServletImplClass");
        table.put("debugging-enabled", "setDebugging");
        table.put("namespaceURI", "setServiceNamespaceUri");
        table.put("localpart", "setServiceLocalPart");
        table.put("auth-method", "setAuthMethod");
        table.put("realm", "setRealm");
        table.put("transport-guarantee", "setTransportGuarantee");
        return table;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("port-component-name".equals(element.getQName())) {
            WebBundleDescriptor bundle2;
            Object parentDesc = this.getParentNode().getDescriptor();
            if (parentDesc instanceof EjbDescriptor) {
                EjbBundleDescriptor bundle3 = ((EjbDescriptor)parentDesc).getEjbBundleDescriptor();
                if (bundle3 != null) {
                    WebServicesDescriptor webServices = bundle3.getWebServices();
                    this.descriptor = webServices.getEndpointByName(value);
                }
            } else if (parentDesc instanceof WebComponentDescriptor && (bundle2 = ((WebComponentDescriptor)parentDesc).getWebBundleDescriptor()) != null) {
                WebServicesDescriptor webServices = bundle2.getWebServices();
                this.descriptor = webServices.getEndpointByName(value);
            }
            if (this.descriptor == null) {
                logger.log(Level.SEVERE, WS_PORT_UNKNOWN, value);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, WebServiceEndpoint endpoint) {
        MessageSecurityBindingDescriptor messageSecBindingDesc;
        Node endpointNode = super.writeDescriptor(parent, nodeName, endpoint);
        WebServiceEndpointRuntimeNode.appendTextChild(endpointNode, "port-component-name", endpoint.getEndpointName());
        WebServiceEndpointRuntimeNode.appendTextChild(endpointNode, "endpoint-address-uri", endpoint.getEndpointAddressUri());
        if (endpoint.implementedByEjbComponent() && endpoint.hasAuthMethod()) {
            Element loginConfigNode = WebServiceEndpointRuntimeNode.appendChild(endpointNode, "login-config");
            WebServiceEndpointRuntimeNode.appendTextChild((Node)loginConfigNode, "auth-method", endpoint.getAuthMethod());
            WebServiceEndpointRuntimeNode.appendTextChild((Node)loginConfigNode, "realm", endpoint.getRealm());
        }
        if ((messageSecBindingDesc = endpoint.getMessageSecurityBinding()) != null) {
            MessageSecurityBindingNode messageSecBindingNode = new MessageSecurityBindingNode();
            messageSecBindingNode.writeDescriptor(endpointNode, "message-security-binding", messageSecBindingDesc);
        }
        WebServiceEndpointRuntimeNode.appendTextChild(endpointNode, "transport-guarantee", endpoint.getTransportGuarantee());
        QName serviceName = endpoint.getServiceName();
        if (serviceName != null) {
            Element serviceQnameNode = WebServiceEndpointRuntimeNode.appendChild(endpointNode, "service-qname");
            WebServiceEndpointRuntimeNode.appendTextChild((Node)serviceQnameNode, "namespaceURI", serviceName.getNamespaceURI());
            WebServiceEndpointRuntimeNode.appendTextChild((Node)serviceQnameNode, "localpart", serviceName.getLocalPart());
        }
        WebServiceEndpointRuntimeNode.appendTextChild(endpointNode, "tie-class", endpoint.getTieClassName());
        if (endpoint.implementedByWebComponent() && endpoint.getServletImplClass() != null) {
            WebServiceEndpointRuntimeNode.appendTextChild(endpointNode, "servlet-impl-class", endpoint.getServletImplClass());
        }
        WebServiceEndpointRuntimeNode.appendTextChild(endpointNode, "debugging-enabled", endpoint.getDebugging());
        Iterator properties = endpoint.getProperties();
        if (properties != null) {
            RuntimeNameValuePairNode propNode = new RuntimeNameValuePairNode();
            while (properties.hasNext()) {
                NameValuePairDescriptor aProp = (NameValuePairDescriptor)properties.next();
                propNode.writeDescriptor(endpointNode, "property", aProp);
            }
        }
        return endpointNode;
    }

    public void writeWebServiceEndpointInfo(Node parent, EjbDescriptor ejb) {
        EjbBundleDescriptor bundle2 = ejb.getEjbBundleDescriptor();
        WebServicesDescriptor webServices = bundle2.getWebServices();
        Collection<WebServiceEndpoint> endpoints = webServices.getEndpointsImplementedBy(ejb);
        for (WebServiceEndpoint next : endpoints) {
            this.writeDescriptor(parent, "webservice-endpoint", next);
        }
    }

    public void writeWebServiceEndpointInfo(Node parent, WebComponentDescriptor webComp) {
        WebBundleDescriptor bundle2 = webComp.getWebBundleDescriptor();
        WebServicesDescriptor webServices = bundle2.getWebServices();
        Collection<WebServiceEndpoint> endpoints = webServices.getEndpointsImplementedBy(webComp);
        for (WebServiceEndpoint next : endpoints) {
            this.writeDescriptor(parent, "webservice-endpoint", next);
        }
    }
}

