/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.impl.base.GMSContextImpl;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class GMSContextFactory {
    private static final Map<String, GMSContext> ctxCache = new HashMap<String, GMSContext>();

    private GMSContextFactory() {
    }

    static GMSContext produceGMSContext(String serverToken, String groupName, GroupManagementService.MemberType memberType, Properties properties) {
        GMSContext ctx = ctxCache.get(groupName);
        if (ctx == null) {
            ctx = new GMSContextImpl(serverToken, groupName, memberType, properties);
            ctxCache.put(groupName, ctx);
        }
        return ctx;
    }

    public static GMSContext getGMSContext(String groupName) {
        return ctxCache.get(groupName);
    }

    public static void removeGMSContext(String groupName) {
        ctxCache.remove(groupName);
    }
}

