/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.StringUtils;

public final class JDK {
    private static int major;
    private static int minor;
    private static int subminor;
    private static int update;

    private JDK(String string) {
        String[] split = string.split("[\\._\\-]+");
        if (split.length > 0) {
            major = new Integer(split[0]);
        }
        if (split.length > 1) {
            minor = new Integer(split[1]);
        }
        if (split.length > 2) {
            subminor = new Integer(split[2]);
        }
        if (split.length > 3) {
            update = new Integer(split[3]);
        }
    }

    public static JDK getVersion(String string) {
        if (string.matches("([0-9]+[\\._\\-]+)*[0-9]+")) {
            return new JDK(string);
        }
        return null;
    }

    public static boolean ok() {
        return major == 1 && minor >= 6;
    }

    public static int getMajor() {
        return major;
    }

    public static int getMinor() {
        return minor;
    }

    public static int getSubMinor() {
        return subminor;
    }

    public static int getUpdate() {
        return update;
    }

    public boolean newerThan(JDK version) {
        if (major > version.getMajor()) {
            return true;
        }
        if (major == version.getMajor()) {
            if (minor > version.getMinor()) {
                return true;
            }
            if (minor == version.getMinor()) {
                if (subminor > version.getSubMinor()) {
                    return true;
                }
                if (subminor == version.getSubMinor()) {
                    if (update > version.getUpdate()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean newerOrEquals(JDK version) {
        return this.newerThan(version) || this.equals(version);
    }

    public boolean olderThan(JDK version) {
        return !this.newerOrEquals(version);
    }

    public boolean olderOrEquals(JDK version) {
        return !this.newerThan(version);
    }

    public static String toStringStatic() {
        return "major: " + JDK.getMajor() + "\nminor: " + JDK.getMinor() + "\nsubminor: " + JDK.getSubMinor() + "\nupdate: " + JDK.getUpdate() + "\nOK ==>" + JDK.ok();
    }

    private static void initialize() {
        major = 1;
        update = 0;
        subminor = 0;
        minor = 0;
        try {
            String jv = System.getProperty("java.version");
            if (!StringUtils.ok(jv)) {
                return;
            }
            String[] ss = jv.split("\\.");
            if (ss.length < 3 || !ss[0].equals("1")) {
                return;
            }
            major = Integer.parseInt(ss[0]);
            minor = Integer.parseInt(ss[1]);
            if ((ss = ss[2].split("_")).length < 1) {
                return;
            }
            subminor = Integer.parseInt(ss[0]);
            if (ss.length > 1) {
                update = Integer.parseInt(ss[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        JDK.initialize();
    }
}

