/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cdi.jsr107;

import com.hazelcast.core.HazelcastInstance;
import fish.payara.cdi.jsr107.impl.NamedCache;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;

public class JSR107Producer {
    HazelcastCore hazelcastCore = HazelcastCore.getCore();

    @Dependent
    @Produces
    CachingProvider getCachingProvider() {
        return this.hazelcastCore.getCachingProvider();
    }

    @Dependent
    @Produces
    CacheManager getCacheManager(InjectionPoint point) {
        Object result = null;
        return this.hazelcastCore.getCachingProvider().getCacheManager();
    }

    @Dependent
    @Produces
    HazelcastInstance getHazelcast() {
        return this.hazelcastCore.getInstance();
    }

    @Produces
    public Cache createCache(InjectionPoint ip) {
        Cache result = null;
        String cacheName = ip.getMember().getDeclaringClass().getCanonicalName();
        NamedCache ncqualifier = ip.getAnnotated().getAnnotation(NamedCache.class);
        CacheManager manager = this.getCacheManager(ip);
        if (ncqualifier != null) {
            Class valueClass;
            Class keyClass;
            String qualifierName = ncqualifier.cacheName();
            if (!"".equals(cacheName)) {
                cacheName = qualifierName;
            }
            if ((result = manager.getCache(cacheName, keyClass = ncqualifier.keyClass(), valueClass = ncqualifier.valueClass())) == null) {
                Class writerFactoryClass;
                MutableConfiguration config = new MutableConfiguration();
                config.setTypes(keyClass, valueClass);
                Class expiryPolicyFactoryClass = ncqualifier.expiryPolicyFactoryClass();
                if (!"Object".equals(expiryPolicyFactoryClass.getSimpleName())) {
                    Factory<Class> factory = FactoryBuilder.factoryOf(expiryPolicyFactoryClass);
                    config.setExpiryPolicyFactory(factory);
                }
                if (!"Object".equals((writerFactoryClass = ncqualifier.cacheWriterFactoryClass()).getSimpleName())) {
                    Factory<Class> factory = FactoryBuilder.factoryOf(writerFactoryClass);
                    config.setCacheWriterFactory(factory);
                }
                config.setWriteThrough(ncqualifier.writeThrough());
                Class loaderFactoryClass = ncqualifier.cacheLoaderFactoryClass();
                if (!"Object".equals(loaderFactoryClass.getSimpleName())) {
                    Factory<Class> factory = FactoryBuilder.factoryOf(loaderFactoryClass);
                    config.setCacheLoaderFactory(factory);
                }
                config.setReadThrough(ncqualifier.readThrough());
                config.setManagementEnabled(ncqualifier.managementEnabled());
                config.setStatisticsEnabled(ncqualifier.statisticsEnabled());
                result = manager.createCache(cacheName, config);
            }
        } else {
            result = manager.getCache(cacheName);
            if (result == null) {
                MutableConfiguration config = new MutableConfiguration();
                config.setManagementEnabled(true);
                config.setStatisticsEnabled(true);
                result = manager.createCache(cacheName, config);
            }
        }
        return result;
    }
}

