/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cdi.jsr107.impl;

import fish.payara.cdi.jsr107.impl.PayaraCacheResolver;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.lang.annotation.Annotation;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheMethodDetails;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.configuration.MutableConfiguration;

public class PayaraCacheResolverFactory
implements CacheResolverFactory,
CacheResolver {
    private CacheManager cacheManager = HazelcastCore.getCore().getCachingProvider().getCacheManager();

    @Override
    public CacheResolver getCacheResolver(CacheMethodDetails<? extends Annotation> cmd) {
        String cacheName = cmd.getCacheName();
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            cache = this.cacheManager.createCache(cacheName, new MutableConfiguration());
        }
        return new PayaraCacheResolver(cache);
    }

    @Override
    public CacheResolver getExceptionCacheResolver(CacheMethodDetails<CacheResult> cmd) {
        CacheResult result = cmd.getCacheAnnotation();
        String cacheName = result.exceptionCacheName();
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            cache = this.cacheManager.createCache(cacheName, new MutableConfiguration());
        }
        return new PayaraCacheResolver(cache);
    }

    @Override
    public <K, V> Cache<K, V> resolveCache(CacheInvocationContext<? extends Annotation> cic) {
        Cache cache = this.cacheManager.getCache(cic.getCacheName());
        if (cache == null) {
            this.cacheManager.createCache(cic.getCacheName(), new MutableConfiguration());
            cache = this.cacheManager.getCache(cic.getCacheName());
        }
        return cache;
    }
}

