/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.FileEntry;
import jcifs.util.Hexdump;

public class SmbShareInfo
implements FileEntry {
    protected String netName;
    protected int type;
    protected String remark;

    public SmbShareInfo() {
    }

    public SmbShareInfo(String netName, int type2, String remark) {
        this.netName = netName;
        this.type = type2;
        this.remark = remark;
    }

    public String getName() {
        return this.netName;
    }

    public int getType() {
        switch (this.type & 0xFFFF) {
            case 1: {
                return 32;
            }
            case 3: {
                return 16;
            }
        }
        return 8;
    }

    public int getAttributes() {
        return 17;
    }

    public long createTime() {
        return 0L;
    }

    public long lastModified() {
        return 0L;
    }

    public long length() {
        return 0L;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SmbShareInfo) {
            SmbShareInfo si = (SmbShareInfo)obj;
            return this.netName.equals(si.netName);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.netName.hashCode();
        return hashCode;
    }

    public String toString() {
        return new String("SmbShareInfo[netName=" + this.netName + ",type=0x" + Hexdump.toHexString(this.type, 8) + ",remark=" + this.remark + "]");
    }
}

