/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.db;

import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;

final class DatabaseContextImpl
extends ContextImpl
implements DatabaseContext {
    private final Database db;

    DatabaseContextImpl(ContextManager contextManager, Database database) {
        super(contextManager, "Database");
        this.db = database;
    }

    public void cleanupOnError(Throwable throwable) {
        DataDictionary dataDictionary;
        if (!(throwable instanceof StandardException)) {
            return;
        }
        StandardException standardException = (StandardException)throwable;
        if (standardException.getSeverity() < 40000) {
            return;
        }
        this.popMe();
        if (standardException.getSeverity() >= 45000 && (dataDictionary = this.db.getDataDictionary()) != null) {
            dataDictionary.disableIndexStatsRefresher();
        }
        if (standardException.getSeverity() == 45000) {
            ContextService.getFactory().notifyAllActiveThreads(this);
            Monitor.getMonitor().shutdown(this.db);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DatabaseContext) {
            return ((DatabaseContextImpl)object).db == this.db;
        }
        return false;
    }

    public int hashCode() {
        return this.db.hashCode();
    }

    public Database getDatabase() {
        return this.db;
    }
}

