/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.internal.codegen.CodeGenerator;
import org.eclipse.persistence.internal.codegen.MethodDefinition;

public class ReflectiveMethodDefinition
extends MethodDefinition {
    protected Vector argumentTypes = new Vector(5);
    protected Class type = null;

    public void addArgument(Class argumentType, String argumentName) {
        this.getArgumentNames().addElement(argumentName);
        this.getArgumentTypes().addElement(argumentType);
    }

    @Override
    protected boolean argumentsEqual(MethodDefinition methodDefinition) {
        Object[] args2;
        Object[] args1 = this.getArgumentTypes().toArray();
        if (args1.length == (args2 = methodDefinition.getArgumentTypes().toArray()).length) {
            int i = 0;
            while (i < args1.length) {
                if (args1[i] != args2[i]) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected Vector getArgumentTypeNames() {
        Vector<String> argumentTypeNames = new Vector<String>();
        Iterator i = this.getArgumentTypes().iterator();
        while (i.hasNext()) {
            argumentTypeNames.add(((Class)i.next()).getName());
        }
        return argumentTypeNames;
    }

    @Override
    public Vector getArgumentTypes() {
        return this.argumentTypes;
    }

    @Override
    protected void writeArguments(CodeGenerator generator) {
        boolean isFirst = true;
        int index = 0;
        while (index < this.getArgumentTypes().size()) {
            Class argument = (Class)this.getArgumentTypes().elementAt(index);
            if (isFirst) {
                isFirst = false;
            } else {
                generator.write(", ");
            }
            if (argument.isArray()) {
                String componentType = argument.getComponentType().getName();
                if (componentType.indexOf(36) != -1) {
                    componentType = componentType.replace('$', '.');
                }
                String componentTypeArrays = String.valueOf(componentType) + "[]";
                generator.write(componentTypeArrays);
            } else {
                String name = argument.getName();
                if (name.indexOf(36) != -1) {
                    name = name.replace('$', '.');
                }
                generator.write(name);
            }
            generator.write(" ");
            generator.write(this.getArgumentNames().elementAt(index));
            ++index;
        }
    }

    public Class getReturnTypeClass() {
        return this.type;
    }

    public void setReturnTypeClass(Class type2) {
        this.type = type2;
    }

    @Override
    public String getReturnType() {
        if (this.getReturnTypeClass() != null) {
            if (this.getReturnTypeClass().isArray()) {
                return String.valueOf(this.getReturnTypeClass().getComponentType().getName()) + "[]";
            }
            return this.getReturnTypeClass().getName();
        }
        return this.returnType;
    }
}

